% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{ciCalculations}
\alias{ciCalculations}
\title{ciCalculations}
\usage{
ciCalculations(eList, startSeed = 494817, verbose = TRUE,
  jitterOn = FALSE, V = 0.2, nBoot = 100, blockLength = 200,
  widthCI = 90)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. 
Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{startSeed}{sets the random seed value. Defaults to 494817. 
This is used to make repeatable output.}

\item{verbose}{logical specifying whether or not to display progress message,
default = TRUE}

\item{jitterOn}{logical, if TRUE, adds "jitter" to the data in an attempt to
avoid some numerical problems.  Default = FALSE.  See Details below.}

\item{V}{numeric a multiplier for addition of jitter to the data, default = 0.2.
See Details below.}

\item{nBoot}{number of times the bootstrap resampling and model estimating is done.
Default is 100, but that will take a long time. Testing should initially be done using
a smaller number like 10.}

\item{blockLength}{integer size of subset, expressed in days.  200 days has 
been found to be a good choice.}

\item{widthCI}{numeric, the width of the confidence intervals. 0.9 means the 
confidence intervals will be calculated with 90\%.}
}
\value{
A data frame with the following columns:
\tabular{ll}{
Year \tab mean decYear value for the year being reported \cr
FNConcLow \tab the lower confidence limit for flow normalized concentration, in mg/L \cr
FNConcHigh \tab  the upper confidence limit for flow normalized concentration, in mg/L \cr
FNFluxLow \tab  the lower confidence limit for flow normalized flux, in kg/day \cr
FNFluxLow \tab  the lower confidence limit for flow normalized flux, in kg/day \cr
}
}
\description{
Function to calculate confidence bands for flow-normalized concentration or 
flow-normalized flux. It returns a data frame which is used as input to the 
functions \code{plotConcHistBoot} and \code{plotFluxHistBoot} which produce
the graphical output.
}
\details{
In some situations numerical problems are encountered in the bootstrap process,
resulting in highly unreasonable spikes in the confidence intervals. The use of
"jitter" can often prevent these problems, but should only be used when it is
clearly needed. It adds a small amount of random "jitter" to the explanatory
variables of the WRTDS model. The V parameter sets the scale of variation in
the log discharge values. The standard deviation of the added jitter is V * standard
deviation of Log Q. The default for V is 0.2. Larger values should generally be avoided,
and smaller values may be sufficient.

Argument values suggested. 
To test the code, nBoot = 10 is sufficient, but for meaningful results 
nBoot = 100 or even nBoot = 500 are more appropriate. blockLength = 200.
widthCI = 90 (90% confidence interval).
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
CIAnnualResults <- ciCalculations(eList,
                                  nBoot = 10)
plotConcHistBoot(eList, CIAnnualResults)

# run in batch mode, using non-stationary flow normalization
# In this example nBoot is set very small, useful for an initial trial run.
# A meaningful application would use nBoot values such as 100 or even 500. 
seriesOut_2 <- runSeries(eList, windowSide = 11)
CIAnnualResults <- ciCalculations(seriesOut_2, 
                     nBoot = 10,
                     blockLength = 200,
                     widthCI = 90)
                     
 plotConcHistBoot(seriesOut_2, CIAnnualResults)

}
}
