% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMCM.R
\name{rMCM}
\alias{rMCM}
\title{Generate Random Samples for Mixture Cure Rate (MCR) Model}
\usage{
rMCM(
  n,
  x,
  w,
  censor,
  alpha,
  beta,
  eta,
  dist = "weibull",
  link = "logit",
  tau = 1
)
}
\arguments{
\item{n}{Integer. Number of observations to simulate.}

\item{x}{Matrix or numeric. Covariate matrix for the latency component (must include intercept if needed).}

\item{w}{Matrix or numeric. Covariate matrix for the cure component (no intercept assumed).}

\item{censor}{Numeric. Maximum censoring time (uniformly distributed).}

\item{alpha}{Numeric. Shape parameter for the survival distribution.}

\item{beta}{Numeric vector. Coefficients for the latency part.}

\item{eta}{Numeric vector. Coefficients for the cure part.}

\item{dist}{Character. Distribution for the latency part. Options: \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"}, \code{"invgauss"}, \code{"exponential"}, \code{"rayleigh"}.}

\item{link}{Character. Link function for cure component. Options: \code{"logit"}, \code{"probit"},\code{"plogit"} ,\code{"rplogit"}, \code{"cauchit"}.}

\item{tau}{A numeric value used when \code{link = "plogit"} or \code{"rplogit"}. Defaults to 1.}
}
\value{
A list with elements:
\describe{
\item{time}{Observed (possibly censored) survival time.}
\item{status}{Event indicator (1 = event, 0 = censored).}
\item{x}{Covariate matrix for the latency component.}
\item{w}{Covariate matrix for the cure component.}
\item{pCcensur}{Percentage of cured individuals.}
\item{pUCcensur}{Percentage of censored cases among the uncured.}
}
}
\description{
Simulates survival data from a mixture cure rate model with covariates and user-defined link and latency distributions. Censoring is applied randomly.
}
\examples{
# Example: Simulating survival data using the inverse Gaussian distribution
library(EMGCR)

n <- 500
beta <- c(1, -1, -2)
eta <- c(0.5, -0.5)
alpha <- 1.5

p <- length(beta)
q <- length(eta)

set.seed(10)
X <- matrix(rnorm(n*(p-1),0,1),n,p-1)
X <- cbind(1,X)

set.seed(20)
W <- matrix(runif(n*q,-1,1),n,q)
W <- scale(W)

max_censoring <- 10

set.seed(1234)
sim_data <- rMCM(n=n, x = X, w = W,
                 censor = max_censoring,
                 beta = beta, eta = eta,
                 alpha = alpha,
                 link = "logit", dist = "invgauss", tau = 1)

names(sim_data)
head(sim_data)
attributes(sim_data)
attr(sim_data, "pCcensur")
attr(sim_data, "pUCcensur")
}
