% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_classes.R, R/pmm2_package.R
\docType{class}
\name{TS2fit-class}
\alias{TS2fit-class}
\title{Base S4 class for storing PMM2 time series model results}
\description{
Base class for storing results of time series model estimation using PMM2
}
\section{Slots}{

\describe{
\item{\code{coefficients}}{numeric vector of estimated parameters}

\item{\code{residuals}}{numeric vector of final residuals}

\item{\code{m2}}{numeric second central moment of initial residuals}

\item{\code{m3}}{numeric third central moment of initial residuals}

\item{\code{m4}}{numeric fourth central moment of initial residuals}

\item{\code{convergence}}{logical or integer code indicating whether algorithm converged}

\item{\code{iterations}}{numeric number of iterations performed}

\item{\code{call}}{original function call}

\item{\code{model_type}}{character string indicating model type}

\item{\code{intercept}}{numeric value of intercept}

\item{\code{original_series}}{numeric vector of original time series}

\item{\code{order}}{list of order parameters}
}}

\section{Slots}{

\describe{
\item{coefficients}{Estimated coefficients}
\item{residuals}{Final residuals}
\item{m2}{Second central moment}
\item{m3}{Third central moment}
\item{m4}{Fourth central moment}
\item{convergence}{Convergence status}
\item{iterations}{Number of iterations performed}
\item{call}{Original call}
\item{model_type}{Model type}
\item{intercept}{Intercept}
\item{original_series}{Original time series}
\item{order}{Model orders}
}
}

