% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_appr_function.R
\name{model.appr}
\alias{model.appr}
\title{Test for Model Appropriateness}
\usage{
model.appr(current.parms, critical.parms, do.not.fit = NULL)
}
\arguments{
\item{current.parms}{A vector containing the indices of the current model.}

\item{critical.parms}{A list containing vectors which specify the critical parameter sets. Needs to be given by index and not by name (for conversion see \code{\link{set.crit.parms}}).}

\item{do.not.fit}{A vector containing the indices of the parameters that are not to be fitted.}
}
\value{
TRUE, if the model is appropriate, FALSE, if it violates the specified critical conditions.
}
\description{
Tests if a model is violating specified critical conditions.
}
\examples{
#define the models to be checked
model1 <- c(1,2,5)
model2 <- c(1,4,5)
#define the critical conditions
crits <- list(c(2,3))

#test the models
model.appr(current.parms = model1, critical.parms = crits)
model.appr(current.parms = model2, critical.parms = crits)
}
