% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fava_functions.R
\name{fava_norm}
\alias{fava_norm}
\title{Compute the normalized Fst of a matrix of compositional vectors}
\usage{
fava_norm(relab_matrix, K = ncol(relab_matrix))
}
\arguments{
\item{relab_matrix}{A matrix or data frame with rows containing non-negative entries that sum to 1. Each row represents
a sample, each column represents a category, and each entry represents the abundance of that category in the sample.
If \code{relab_matrix} contains any metadata, it must be on the left-hand side of the matrix,
the right \code{K} entries of each row must sum to 1, and \code{K} must be specified. Otherwise, all entries of
each row must sum to 1.}

\item{K}{Optional; an integer specifying the number of categories in the data. Default is \code{K=ncol(relab_matrix)}.}
}
\value{
A numeric value between 0 and 1.
}
\description{
This function computes the normalized Fst given the number of rows and the mean abundance of the most abundant category.
We employ the normalization employed in the \href{https://github.com/MaikeMorrison/FSTruct}{FSTruct package} by
Morrison, Alcala, and Rosenberg (2020) \doi{doi:10.1111/1755-0998.13647}.
}
\examples{
# Compute the weighted fava of
# the following compositional vectors:
q1 = c(1,   0,   0,   0)
q2 = c(0.5, 0.5, 0,   0)
q3 = c(1/4, 1/4, 1/4, 1/4)
q4 = c(0,   0,   1,   0)
relative_abundances = matrix(c(q1, q2, q3, q4),
                  byrow = TRUE, nrow = 4)

fava_norm(relative_abundances)
}
