% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_simulation.R
\name{run_simulation}
\alias{run_simulation}
\alias{run_simulation.boin_design}
\alias{run_simulation.i3plus3_design}
\alias{run_simulation.mtpi2_design}
\alias{run_simulation.g3plus3_design}
\alias{run_simulation.threethree_design}
\alias{run_simulation.default}
\title{Run Simulations for Phase I Dose-Finding Designs}
\usage{
run_simulation(design, p.true, mtd.true, ...)

\method{run_simulation}{boin_design}(design, p.true, mtd.true, ...)

\method{run_simulation}{i3plus3_design}(design, p.true, mtd.true, ...)

\method{run_simulation}{mtpi2_design}(design, p.true, mtd.true, ...)

\method{run_simulation}{g3plus3_design}(design, p.true, mtd.true, ...)

\method{run_simulation}{threethree_design}(design, p.true, mtd.true, ...)

\method{run_simulation}{default}(design, p.true, mtd.true, ...)
}
\arguments{
\item{design}{A design object created by one of the design constructor functions
(\code{\link{design_boin}}, \code{\link{design_i3plus3}}, \code{\link{design_mtpi2}},
\code{\link{design_g3plus3}}, or \code{\link{design_3plus3}}).}

\item{p.true}{A vector or matrix containing the true toxicity probabilities of
the investigational dose levels.}

\item{mtd.true}{A numeric value or vector specifying the true MTD.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A list containing 'selection' (a dataframe showing selection percentages and
  metrics POS, PCS, PUS), 'allocation' (a dataframe showing participant allocation across
  dose levels), and 'setup' (a list containing design parameters and simulation settings).
}
\description{
Generic function to conduct computer simulations for phase I dose-finding designs.
}
\examples{
# Create design specifications
boin <- design_boin(pT = 0.25, EI = c(0.15, 0.35), ncohort = 10)
i3 <- design_i3plus3(pT = 0.25, EI = c(0.2, 0.3), ncohort = 10)

# Define toxicity scenarios
p.true <- matrix(c(0.05, 0.10, 0.20, 0.30, 0.45,
                   0.10, 0.15, 0.25, 0.35, 0.50),
                 nrow = 2, byrow = TRUE)
# Binary matrix indicating true MTD for each scenario (dose 3 for both)
mtd.true <- matrix(c(0, 0, 1, 0, 0,
                     0, 0, 1, 0, 0),
                   nrow = 2, byrow = TRUE)

# Run simulations
\donttest{
sim_boin <- run_simulation(boin, p.true = p.true, mtd.true = mtd.true)
sim_i3 <- run_simulation(i3, p.true = p.true, mtd.true = mtd.true)
}

}
