% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredist.R
\name{fredist}
\alias{fredist}
\title{Compute the Generalized Fréchet Distance Between Two Trajectories}
\usage{
fredist(traj1, traj2, form)
}
\arguments{
\item{traj1}{A numeric matrix or data.frame representing the first trajectory.
The first column must be time points, and the remaining columns should be one
or more variables observed at each time point (e.g., Variable1, Variable2, ...).
Each row corresponds to a single time point.}

\item{traj2}{A numeric matrix or data.frame representing the second trajectory.
The format should be the same as for \code{traj1}, where the first column is
time, and the subsequent columns are variables.}

\item{form}{A character string specifying the return format.
Should be either \code{"scalar"} to return the scalar Fréchet distance,
or \code{"matrix"} to return the full dynamic programming matrix.}
}
\value{
A numeric value or matrix.
If \code{form = "scalar"}, returns the Fréchet distance between the two trajectories as a single numeric value.
If \code{form = "matrix"}, returns the dynamic programming matrix used to compute the distance.
}
\description{
Calculates the discrete Fréchet distance between two trajectories, which is
used as the distance metric in clustering algorithms for longitudinal data.
}
\details{
This function is primarily used internally by clustering functions to evaluate
the similarity between trajectories based on the Fréchet distance.
It is used in the \code{mfkml} function and for generating the distance array
used in \code{SFclust} function.
}
\examples{
# Example trajectories with 3 variables
traj1 <- data.frame(
  Time = 1:4,
  Variable1 = c(1.2, 1.4, 1.6, 1.8),
  Variable2 = c(2.3, 2.1, 2.0, 1.9),
  Variable3 = c(3.1, 3.3, 3.5, 3.7)
) 
traj2 <- data.frame(
  Time = 1:3,
  Variable1 = c(2.0, 2.2, 2.4),
  Variable2 = c(3.0, 2.9, 2.8),
  Variable3 = c(1.0, 1.1, 1.2)
)

# Compute Fréchet distance (scalar output)
fredist(traj1, traj2, form = "scalar")

# Compute Fréchet distance matrix
fredist(traj1, traj2, form = "matrix")

}
