% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLAG.R
\name{FLAG}
\alias{FLAG}
\title{FLAG is the main function to fulfill the whole process.}
\usage{
FLAG(
  data,
  scale.var = TRUE,
  low.rank = NULL,
  infer = "llr",
  eps = 1e-07,
  crit.loglik = 1e-04
)
}
\arguments{
\item{data}{Matrix, with size n*p.}

\item{scale.var}{Logical, whether to scale the variance of X to 1/p, default to be T(RUE).}

\item{low.rank}{Logical, whether to use low rank update to shrink the time of eigen-decomposition of XX^T, default to be TRUE when sample size larger than 1000.}

\item{infer}{Character, option of different tests of inference where 'llr' for likelihood ratio test and 'wald' for Wald test based on Fisher Information Matrix.}

\item{eps}{Numeric, a small term to avoid numerical problems, default to be 1e-7.}

\item{crit.loglik}{Numeric, the criteria of the change ratio of log likelihood to stop.}
}
\value{
List,
the estimated precision matrix,
the p-value of precision matrix estimation,
the edge existence using Bonferroni correction,
the edge existence using false discovery rate,
the matrix of estimated eta,
the standard error or estimated eta,
the matrix of estimated partial correlation rho,
the standard error or estimated partial correlation rho,
the p-value of partial correlation matrix estimation,
the matrix of estimated sigma_a^2,
the standard error or estimated sigma_b^2,
the execution time.
}
\description{
FLAG is the main function to fulfill the whole process.
}
\examples{
N = 20
P = 10
pi = 0.2
Pre = matrix(sample(c(0.2, 0.4), P*P, replace = TRUE) * rbinom(P*P, 1, pi), nrow = P, ncol = P )
Pre[lower.tri(Pre)] = t(Pre)[lower.tri(Pre)]
diag(Pre) = 1
vals <- eigen(Pre)$values
Sigma = solve(Pre)
Z = MASS::mvrnorm(N, rep(0, P), Sigma)
Z.c = scale(Z, center = TRUE, scale = FALSE)
results = FLAG(Z.c)

}
