% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postregression_functions.R
\name{diff_AME}
\alias{diff_AME}
\title{Difference between AMEs in each group}
\usage{
diff_AME(object, AME, baseline_group, plot = TRUE)
}
\arguments{
\item{object}{An object from \code{\link{FactorHet}} or
\code{\link{FactorHet_mbo}}.}

\item{AME}{An object containing the average marginal effects estimated using
\code{\link{AME}}.}

\item{baseline_group}{An integer that denotes the baseline group. The
function will show the difference in AMEs from this group, i.e. Group
\code{k} - Group \code{baseline_group}.}

\item{plot}{A logical value as to whether the function should print the plot
immediately or quietly provide an object containing the plot and data. The
default is \code{TRUE}.}
}
\value{
Returns a named list with the underlying data (\code{"data"}) and the
  plot (\code{"plot"}).
}
\description{
Computes the differences between AME between two groups with an
  accompanying standard error.
}
\examples{
  # Fit with two groups and fixed lambda for quick illustration
  \donttest{
  data(immigration)
  set.seed(15)
  fit <- FactorHet(formula = Chosen_Immigrant ~ Country + Ed,
    design = immigration, group = ~ CaseID, task = ~ contest_no,
    choice_order = ~ choice_id, lambda = 1e-2,
    control = FactorHet_control(init_method = 'random_member'),
    K = 2)
  fit_AME <- AME(fit)
  diff_AME(fit, fit_AME, baseline_group = 2)
  }
}
