% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_create_wavelet_stats.R
\name{create_wavelet_stats}
\alias{create_wavelet_stats}
\title{create_wavelet_stats}
\usage{
create_wavelet_stats(
  wavelet,
  tag_ID,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{wavelet}{An object of class "analyze.wavelet" from package
'WaveletComp'}

\item{tag_ID}{Unique tag identification number in a vector of characters.
E.g. "123456"}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A data frame containing the seven wavelet statistics for each
period. One observation is available per period per day:
\itemize{
\item Amplitude_mean
\item Amplitude_variance
\item Mean_sq_power
\item Power_mean
\item Power_variance
\item Phase_mean
\item Phase_variance
}
}
\description{
\code{create_wavelet_stats} aggregates the wavelet variables over the specified
time periods
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load my.w wavelet object
my.w <- readRDS(file.path(filepath, "data/1_Wavelets/data_wavelet.rds"))

# Run create_wavelet_stats function on wavelet object
waveStats <- create_wavelet_stats(
  wavelet = my.w,
  tag_ID = "data",
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
