% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENoisyFit.R
\name{CENoisyFit}
\alias{CENoisyFit}
\title{Cross-Entropy estimation}
\usage{
CENoisyFit(
  x,
  rawdata,
  rho,
  maxiter,
  alpha,
  nsim,
  nrepsInt,
  xiInst,
  betaInst,
  eps,
  r = 5,
  weight
)
}
\arguments{
\item{x}{list: sequence of integers 1,...,K, where K is the mumber of datasets. Set x = 1 in case
of a single dataset.}

\item{rawdata}{either a list of vectors or a vector: in the former case, each
vector contains a dataset to be used for estimation.}

\item{rho}{real in (0,1): parameter determining the quantile of the log-likelihood values to be used at each iteration.}

\item{maxiter}{non-negative integer: maximum number of iterations.}

\item{alpha}{real in (0,1): smoothing parameter.}

\item{nsim}{non-negative integer: number of replications used in the normal and lognormal updating.}

\item{nrepsInt}{non-negative integer: number of replications used in the Monte Carlo estimate of the normalizing constant.}

\item{xiInst}{non-negative real: shape parameter of the instrumental GPD.}

\item{betaInst}{non-negative real: scale parameter of the instrumental GPD.}

\item{eps}{non-negative real: tolerance for the stopping criterion of the noisy Cross-Entropy method.}

\item{r}{positive integer: length of window to be used in the stopping criterion.}

\item{weight}{'cau' or 'exp': name of weight distribution.}
}
\value{
For each dataset, a list with the following elements is returned:

V (nreps x 12) matrix: updated mean and variance of the distributions used in the stochastic program.
nit (positive integer): number of iterations needed for convergence.
loglik (scalar): maximized log-likelihood.
}
\description{
This function estimates a dynamic mixture by means of the noisy Cross-Entropy method.
Currently only implemented for the lognormal - generalized Pareto case,
with Cauchy or exponential weight. This
is mainly an auxiliary function, not suitable for the final user. Use CeNoisyFitBoot instead.
}
\details{
See Rubinstein and Kroese (2004, chap. 6).
}
\examples{
\donttest{maxiter = 10
alpha = .5
rho = .05
eps = 1e-2
nsim = 1000
nrepsInt = 1000
xiInst = 3
betaInst = 3
r = 5
res <- CENoisyFit(1,Metro2019,rho,maxiter,alpha,nsim,nrepsInt,xiInst,betaInst,eps,r,'exp')}

}
\references{
{
\insertRef{rubio4}{FitDynMix}
}
}
\seealso{
CENoisyFitBoot
}
