% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Rotterdam_df}
\alias{Rotterdam_df}
\title{Breast Cancer Prognostic Data (Rotterdam Study)}
\format{
A data frame with 2,982 observations and 15 variables:
\describe{
  \item{pid}{Patient identifier (integer)}
  \item{year}{Year of surgery (integer)}
  \item{age}{Age at diagnosis (integer)}
  \item{meno}{Menopausal status (integer indicator)}
  \item{size}{Tumor size category (factor)}
  \item{grade}{Tumor grade (integer)}
  \item{nodes}{Number of positive lymph nodes (integer)}
  \item{pgr}{Progesterone receptor level (integer)}
  \item{er}{Estrogen receptor level (integer)}
  \item{hormon}{Hormonal therapy received (integer indicator)}
  \item{chemo}{Chemotherapy received (integer indicator)}
  \item{rtime}{Relapse-free survival time in days (numeric)}
  \item{recur}{Recurrence indicator (integer)}
  \item{dtime}{Time to death in days (numeric)}
  \item{death}{Death indicator (integer)}
}
}
\source{
Data taken from the survival package version 3.8-3
}
\usage{
data(Rotterdam_df)
}
\description{
This dataset, Rotterdam_df, provides prognostic factors for breast cancer patients
used in the studies of Royston and Altman. The dataset includes 2,982 observations
and 15 variables, covering patient demographics, tumor characteristics, treatments,
and outcomes. Some observations contain missing values.
}
\details{
The dataset name has been kept as 'Rotterdam_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
