% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_gri.R
\name{v_gri_core}
\alias{v_gri_core}
\title{Core Function For the GRI Tree Volume Calculation}
\usage{
v_gri_core(species_id, dbh_cm, height_m, v_param)
}
\arguments{
\item{species_id}{Vector of species ids (see \code{\link{v_gri}}), but for
this core function to work, \code{species_id} must be provided as
\code{character}. This will and should be not checked inside this function,
because if used as intended, that has happened before calling it.}

\item{dbh_cm}{Vector of breast height diameters (see \code{\link{v_gri}})}

\item{height_m}{Vector of tree heights (see \code{\link{v_gri}})}

\item{v_param}{An internally provided object with appropriate species (group)
specific paramters}
}
\value{
Tree wood volume (see \code{\link{v_gri}})
}
\description{
See documentation of \code{\link{v_gri}} for most information, this function
is the workhorse behind, and should never be called directly by a user.
}
\details{
The function \code{v_gri} is fully vectorized, inputs are recyled according
to the tibble rules
}
\keyword{internal}
