% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoubleWeightedFuzzyHiperGeometricNaiveBayes.R
\name{DWFuzzyHipergeometricNaiveBayes}
\alias{DWFuzzyHipergeometricNaiveBayes}
\title{Double Weighted Fuzzy Hipergeometric Naive Bayes}
\usage{
DWFuzzyHipergeometricNaiveBayes(
  train,
  cl,
  cores = 2,
  fuzzy = TRUE,
  wdelta,
  weta
)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}

\item{wdelta}{vector weight each class}

\item{weta}{vector  weight each feature}
}
\value{
A vector of classifications
}
\description{
\code{DWFuzzyHipergeometricNaiveBayes} Double Weighted Fuzzy Hipergeometric Naive Bayes
}
\examples{

set.seed(1)

substituir_zero <- function(x) {
  if (x == 0) {
    while(1){
     new_valor <- rhyper(1,3,30,10)
      if(new_valor != 0){
        return(new_valor)
      }
    }
  } else {
    return(x)
  }
}

#Building dataframe
class1 <- data.frame(rhyper(72,3,30,10), 
                     sample(seq(1,5),72,replace = TRUE), class = "Bem treinado")
colnames(class1)[1] <- "sucessos"
class1$sucessos <- sapply(class1$sucessos, substituir_zero)
colnames(class1)[2] <- "tentativas"
colnames(class1)[3] <- "avaliação"
class2 <- data.frame(rhyper(72,3,17,12), 
                     sample(seq(4,7),72,replace = TRUE), class = "Mediano")
colnames(class2)[1] <- "sucessos"
#class2$sucessos <- ifelse(class2$sucessos == 0, 2, class2$sucessos)
colnames(class2)[2] <- "tentativas"
colnames(class2)[3] <- "avaliação"
class3 <- data.frame(rhyper(72,3,9,11),
                     sample(seq(7,10),72,replace = TRUE), class = "Precisa treinar")
colnames(class3)[1] <- "sucessos"
#class3$sucessos <- ifelse(class3$sucessos == 0, 3, class3$sucessos)
colnames(class3)[2] <- "tentativas"
colnames(class3)[3] <- "avaliação"
data <- rbind(class1,class2,class3)

# Weights
weta1 <- c(0.22, 0.33, 0.45)
wdelta1 <- c(0.33,0.33,0.33) 

#spliting dataframe
split <- caTools::sample.split(t(data[, 1]), SplitRatio = 0.7)
Train <- subset(data, split == "TRUE")
Test <- subset(data, split == "FALSE")

test <- Test[, -3]
fit_NHT <- DWFuzzyHipergeometricNaiveBayes(
 train = Train[, -3],
 cl = Train[, 3], cores = 2,
 fuzzy = TRUE,
 wdelta = wdelta1,
 weta = weta1)

pred_NHT <- predict(fit_NHT, test)



}
\references{
\insertRef{ferreira2025new}{FuzzyClass}
}
