#' @keywords internal
create_GARCHXobj <- function(eps, X, order, d, delta, r, alpha.level, adjust.method){
  # Create attributes for the object
  fit <- NULL
  fit$eps <- eps
  fit$selectedX <- X
  fit$order <- order
  fit$d <- d
  fit$delta <- delta
  fit$r <- r
  fit$alpha.level <- alpha.level
  fit$adjust.method <- adjust.method

  # Initialize omega, alpha, beta, and pi coefficients as NA
  fit$omega <- NA
  fit$alpha <- NA
  fit$beta <- NA
  fit$pi <- NA
  fit$selectedX_index <- NA
  fit$p.values <- NA
  fit$Likelihood <- NA

  # Assign class to object
  fit$call <- match.call()
  class(fit) <- "GARCHX"

  # Return object
  return(fit)
} # End create_GARCHXobj
