% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{vcov.lmgce}
\alias{vcov.lmgce}
\title{Extract \code{\link{lmgce}} Model's Variance-Covariance Matrix}
\usage{
\method{vcov}{lmgce}(object, ...)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{...}{additional arguments.}
}
\value{
A matrix of the estimated covariances between the parameter estimates
 in the linear predictor of the \code{\link{lmgce}} model.
}
\description{
Returns the variance-covariance matrix of the main parameters of a
\code{\link{lmgce}} object
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}
vcov(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
