% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_hotspots.r
\name{pois.lppm}
\alias{pois.lppm}
\title{Fit a Poisson point process model to a point pattern dataset on a linear network}
\usage{
pois.lppm(PP, formula, data, subwin = NULL, r_max = NULL)
}
\arguments{
\item{PP}{Input, a point pattern object (ppp) of spatstat.}

\item{formula}{An R formula to estimate the first order model.
This formula can contain objects of full size. \code{PP} should be on the
left side of the formula.}

\item{data}{Data from where the formula takes objects.
Must be acceptable by the function lppm of spatstat.linnet.}

\item{subwin}{A part of the observation window of \code{PP} to be used for
estimating the second order structure. NULL means that the full point pattern
is used. Typically this is feasible (not too time consuming).}

\item{r_max}{The maximum distance on which the K-function is evaluated.
Default is computed as \eqn{\sqrt{A}/10}{sqrt(A)/10} where \eqn{A}{A} is the
area of the window of observation of \code{X}.}
}
\description{
Fit a Poisson point process model to a point pattern dataset on a linear network.
This function is provided in \pkg{GET} to support \code{\link{hotspots.poislpp}} and
\code{\link{hotspots.MatClustlpp}}. See the hotspots vignette available
by starting R, typing \code{library("GET")} and \code{vignette("GET")}.
}
\details{
The function \code{pois.lppm}, can be used to estimate the inhomogeneous
Poisson point process model on linear network. This function provides the
\code{firstordermodel}, i.e. the regression model of dependence of crashes on
the spatial covariates, \code{EIP}, i.e. estimated inhomogeneous intensity
from the data and \code{secondorder}, i.e. estimation of the inhomogeneous
K-function. The \code{plot} of the \code{secondorder} provides diagnostics,
if the model is adequate for the data. If the estimated $K$-function lies
close to the theoretical line, the data does not report any clustering, and
the function \code{hotspots.poislpp} can be used for final hotspots detection.
If the estimated K-function does not lie close to the theoretical line, and
it is above, the data report clustering, and the a clustered point pattern
model must be fitted to the data and hotspots detected using this clustered
model instead.
}
