M.step_sem <-
function(x, s){ 
  P <- ncol(x)
  N <- nrow(x)
  X <- data.frame(x)
  rownames(X) <- NULL
  K <- length(unique(s))
  X_cluster <- split(X, s) 
  
  pi <- rep(NA, K)
  mu <- matrix(NA,K, P)
  sigma <- array(0, dim = c(P, P, K)) 
  
  for (i in 1:K) {
    
    pi[i] <- nrow(X_cluster[[i]])/N
    mu[i,] <- colMeans(X_cluster[[i]])
    X_centered <- sweep(X_cluster[[i]], 2, mu[i,])
    X_centered <- as.matrix(X_centered) 
    sigma[ , ,i] <- (t(X_centered) %*% X_centered) / nrow(X_cluster[[i]])
    
  }
  
  param <- list(pi, mu, sigma)
  
  return(param)
  
}
