% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.gw.coordinates.R
\name{compute.gw.coordinates}
\alias{compute.gw.coordinates}
\title{Compute Genome-wide Plotting Coordinates}
\usage{
compute.gw.coordinates(grin.res, scl = 1e+06)
}
\arguments{
\item{grin.res}{GRIN results, typically the output of the \code{grin.stats} function.}

\item{scl}{Chromosome unit length in base pairs. Default is 1,000,000, meaning each chromosome is divided into segments of 1 million base pairs for plotting.}
}
\value{
A list identical in structure to the original \code{grin.res} object, with the following additions:
\describe{
\item{gene.hits}{Unchanged. GRIN gene-level summary statistics, including hit counts and p/q-values.}
\item{gene.lsn.data}{Unchanged. Gene-lesion overlaps showing which lesion affects which gene for each patient.}
\item{lsn.data}{Input lesion data with added \code{x.start} and \code{x.end} columns for genome-wide coordinates.}
\item{gene.data}{Input gene annotation data with added \code{x.start} and \code{x.end} columns for genome-wide coordinates.}
\item{chr.size}{Chromosome size table (22 autosomes + X and Y) with added \code{x.start} and \code{x.end} columns for plotting.}
\item{gene.index}{Mapping of \code{gene.lsn.data} rows to their corresponding chromosomes.}
\item{lsn.index}{Mapping of \code{gene.lsn.data} rows to their corresponding lesions.}
}
}
\description{
Computes and assigns genome-wide plotting coordinates to lesion, gene, and chromosome data for use in genome-wide lesion plots.
}
\details{
This function processes the GRIN results to add genome-wide x-axis coordinates necessary for plotting lesions and genes across all chromosomes. It divides each chromosome into segments based on the specified \code{scl} value and computes cumulative start and end positions across chromosomes to ensure a continuous x-axis. Specifically:
\itemize{
\item Chromosome sizes are updated to include \code{x.start} and \code{x.end} columns, where each chromosome starts where the previous one ends.
\item Gene and lesion data are similarly updated with \code{x.start} and \code{x.end} coordinates, scaled by \code{scl}, and adjusted for cumulative chromosome positions.
}
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Run GRIN model
grin.results <- grin.stats(lesion_data,
                           hg38_gene_annotation,
                           hg38_chrom_size)

# Assign genome-wide coordinates for plotting
genome.coord <- compute.gw.coordinates(grin.results)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{grin.stats}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
