% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.stats.lsn.plot.R
\name{grin.stats.lsn.plot}
\alias{grin.stats.lsn.plot}
\title{GRIN Statistics Lesions Plot}
\usage{
grin.stats.lsn.plot(grin.res, feature = NULL, lsn.clrs = NULL, expand = 5e-04)
}
\arguments{
\item{grin.res}{GRIN results for genes or regulatory elements, as returned by the \code{\link{grin.stats}} function.}

\item{feature}{Ensembl ID of a feature of interest. This can be either a gene (e.g., Ensembl gene ID) or a regulatory region from Ensembl Regulatory Build or FANTOM5 project.}

\item{lsn.clrs}{Named vector of colors for each lesion type. If not provided, colors are automatically assigned using \code{\link{default.grin.colors}}.}

\item{expand}{Numeric value that controls the proportion of the flanking region (upstream/downstream) around the gene to be included. Default is \code{0.0005}. Set to \code{0} to restrict the plot strictly to the locus boundaries.}
}
\value{
A two-panel plot showing lesion distribution and GRIN statistics for a given gene or regulatory feature, without a transcript annotation panel.
}
\description{
Generates a plot showing all lesion types that span a specified gene or regulatory feature with GRIN stats added.
}
\details{
The plot consists of two panels:
\itemize{
\item \strong{Top panel}: Displays all lesion types overlapping the selected gene or regulatory feature. Lesions are color-coded by type, as indicated in the legend.
\item \strong{Bottom panel}: Summarizes GRIN statistics for the feature, including the number of subjects affected per lesion type, and the corresponding \eqn{-\log_{10}(p)} and \eqn{-\log_{10}(q)} values for significance.
}

This plot is particularly useful for regulatory features, which typically lack transcript structure. Therefore, no transcript or exon structure is shown.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Run GRIN analysis
grin.results <- grin.stats(lesion_data,
                           hg38_gene_annotation,
                           hg38_chrom_size)

# Plot lesion and GRIN stats for a gene of interest (e.g., WT1)
grin.stats.lsn.plot(grin.results, feature = "ENSG00000184937")

# Can also be also used for regulatory features without transcript panels
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{grin.stats}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
