% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.grin.xlsx.R
\name{write.grin.xlsx}
\alias{write.grin.xlsx}
\title{Write GRIN Results to Excel File}
\usage{
write.grin.xlsx(grin.result, output.file)
}
\arguments{
\item{grin.result}{A list returned by the \code{\link{grin.stats}} function, containing GRIN analysis output.}

\item{output.file}{A character string specifying the name of the output Excel file. Must end with \code{".xlsx"}.}
}
\value{
The function creates a multi-sheet Excel file at the specified location. The file contains the following sheets:
\itemize{
\item \code{gene.hits}: The GRIN results table. Includes gene annotation, number of subjects affected by each lesion type (e.g., gain, loss, mutation), total lesion hits per gene, and associated p-values and FDR-adjusted q-values for the probability of lesion enrichment.
\item \code{gene.lsn.data}: A table where each row corresponds to a lesion overlapping a specific gene. Columns include \code{"gene"} (Ensembl gene ID) and \code{"ID"} (patient identifier).
\item \code{lsn.data}: The input lesion dataset used in the GRIN analysis.
\item \code{gene.data}: The input gene annotation dataset, typically retrieved from Ensembl.
\item \code{chr.size}: A table listing the size (in base pairs) of chromosomes 1:22, X, and Y.
\item \code{interpretation}: A guide to understanding the structure and content of each sheet, with detailed descriptions of columns in the \code{gene.hits} results table.
\item \code{method.paragraph}: A summary of the GRIN methodology, including relevant references for citation.
}
}
\description{
Writes GRIN results to an Excel file containing multiple sheets. The output includes the GRIN summary statistics, input data (lesion and gene annotation), chromosome sizes, gene-lesion overlaps, and explanatory metadata to help with the results interpretation.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Run GRIN analysis using lesion, gene, and chromosome size data:
grin.results <- grin.stats(lesion_data,
                           hg38_gene_annotation,
                           hg38_chrom_size)

# Write results to an Excel file:
tmp_file <- file.path(tempdir(), "GRIN_Results.xlsx")
write.grin.xlsx(grin.results, output.file = tmp_file)
if (file.exists(tmp_file)) file.remove(tmp_file)
}
\references{
Pounds, S., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{grin.stats}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
