% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{infoPlot}
\alias{infoPlot}
\title{Calculate item information}
\usage{
infoPlot(
  fit,
  selected_item,
  type = "icc",
  theta = seq(-4, 4, 0.1),
  base_size = 16,
  line_size = 1,
  cal_option = "D",
  facet = FALSE
)
}
\arguments{
\item{fit}{an object from \code{\link{runGRM}}}

\item{selected_item}{a numeric indicating for what items the function makes plots}

\item{type}{a character indicating the type of plots
\itemize{
\item{\code{icc}} Test information
\item{\code{tcc}} Total Test information
}}

\item{theta}{a numeric indicating latent traits}

\item{base_size}{a numeric indicating the base font size}

\item{line_size}{a numeric indicating the size of line}

\item{cal_option}{a character indicating the plot colour  specified in
\code{\link[ggplot2]{scale_color_viridis_d}} (default = \code{D})}

\item{facet}{a logical. If TRUE, the plot is faceted by items.
(default = \code{FALSE}).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Calculate item information
}
\details{
This makes either item information plots or
total information plot
}
\examples{

grm_dt <- genData(eta = genTheta(nsample = 500, nfac = 1),
                 ipar = genIRTpar(nitem = 10, ncat = 3, nfac = 1))

fit <- runGRM(dat = grm_dt,
            lav.syntax = genLavSyn(dat = grm_dt, nfac = 1),
            estimator = "WL")
infoPlot(fit, selected_item=1:4, type = "icc", base_size = 16)

}
