% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTAPauto.R
\name{auto_gtap_data}
\alias{auto_gtap_data}
\title{Process GTAP Data Automation with Flexible Output Options}
\usage{
auto_gtap_data(
  experiment,
  input_path = NULL,
  output_path = NULL,
  sl4_suffix = "",
  har_suffix = "",
  process_sl4_vars = NULL,
  process_har_vars = NULL,
  mapping_info = "GTAPv7",
  sl4_mapping_info = NULL,
  har_mapping_info = NULL,
  sl4_extract_method = "get_data_by_dims",
  har_extract_method = "get_data_by_var",
  sl4_priority = NULL,
  har_priority = NULL,
  sl4_convert_unit = NULL,
  har_convert_unit = NULL,
  decimals = 4,
  rename_columns = TRUE,
  region_select = NULL,
  sector_select = NULL,
  subtotal_level = FALSE,
  plot_data = TRUE,
  output_formats = NULL,
  sl4_output_name = "sl4.plot.data",
  har_output_name = "har.plot.data",
  macro_output_name = "GTAPMacro",
  add_scenario_ranking = FALSE,
  rank_column = "ScenarioRank"
)
}
\arguments{
\item{experiment}{Character vector. Case names to process.}

\item{input_path}{Character. Path to the input folder.}

\item{output_path}{Character. Path to the output folder.}

\item{sl4_suffix}{Character. Custom suffix for SL4 files (e.g., \code{""}, \code{"-custom"}).}

\item{har_suffix}{Character. Custom suffix for HAR files (e.g., \code{"-WEL"}).}

\item{process_sl4_vars}{Character, \code{NULL}, or \code{FALSE}. Variables to extract from SL4 data:
\itemize{
\item Character vector: Specific variable names.
\item \code{NULL}: Extract all.
\item \code{FALSE}: Skip SL4 processing.
}}

\item{process_har_vars}{Character, \code{NULL}, or \code{FALSE}. Variables to extract from HAR data:
\itemize{
\item Character vector: Specific variable names.
\item \code{NULL}: Extract all.
\item \code{FALSE}: Skip HAR processing.
}}

\item{mapping_info}{Character. Metadata mode for variable descriptions and units.
Options: \code{"GTAPv7"} (default), \code{"Yes"}, \code{"No"}, \code{"Mix"}.
See \code{\link[=add_mapping_info]{add_mapping_info()}} for full details.}

\item{sl4_mapping_info}{Data frame or \code{NULL}. Mapping for SL4 variables. Must include columns \code{"Variable"}, \code{"Description"}, and \code{"Unit"}.}

\item{har_mapping_info}{Data frame or \code{NULL}. Mapping for HAR variables, structured as above.}

\item{sl4_extract_method}{Character. SL4 extraction method: \code{"get_data_by_dims"}, \code{"get_data_by_var"}, or \code{"group_data_by_dims"}.}

\item{har_extract_method}{Character. HAR extraction method. Same options as above.}

\item{sl4_priority}{Optional list. Required only when \code{sl4_extract_method} is \code{"group_data_by_dims"}. Specifies priority rules for SL4 data grouping.}

\item{har_priority}{Optional list. Required only when \code{har_extract_method} is \code{"group_data_by_dims"}. Specifies priority rules for HAR data grouping.}

\item{sl4_convert_unit}{Character or \code{NULL}. Optional SL4 unit conversion.
Valid options: \code{"mil2bil"}, \code{"bil2mil"}, \code{"pct2frac"}, \code{"frac2pct"}.
See \code{\link{convert_units}} for details.}

\item{har_convert_unit}{Character or \code{NULL}. Optional HAR unit conversion. Same options as above.}

\item{decimals}{Integer or \code{NULL}. Number of decimal places to round numeric values. Set to \code{NULL} to disable rounding.}

\item{rename_columns}{Logical. If \code{TRUE} (default), renames GTAP codes (e.g., \code{"REG"} → \code{"Region"}, \code{"COMM"} → \code{"Commodity"}).}

\item{region_select}{Optional character vector. Filters data to selected regions.
Applies only to the \code{"REG"} column, which is fixed and cannot be modified.}

\item{sector_select}{Optional character vector. Filters data to selected sectors.
Applies only to the \code{"ACTS"} and \code{"COMM"} columns, which are fixed and cannot be modified.}

\item{subtotal_level}{Logical. If \code{TRUE}, includes subtotal rows. Default is \code{FALSE}.}

\item{plot_data}{Logical. If \code{TRUE}, generates plot-ready data and assigns to specified variable names.}

\item{output_formats}{Character vector or list. Output formats for export. Valid values: \code{"csv"}, \code{"stata"}, \code{"rds"}, \code{"txt"}.}

\item{sl4_output_name}{Character. Variable name to assign SL4 output. Default: \code{"sl4.plot.data"}.}

\item{har_output_name}{Character. Variable name to assign HAR output. Default: \code{"har.plot.data"}.}

\item{macro_output_name}{Character. Variable name to assign macro output. Default: \code{"GTAPMacro"}.}

\item{add_scenario_ranking}{Logical or \code{"merged"}. Adds a numeric index for each scenario:
\itemize{
\item \code{TRUE}: Adds a ranking column.
\item \code{"merged"}: Also prefixes experiment names with the rank.
}}

\item{rank_column}{Character. Name of the ranking column. Default is \code{"ScenarioRank"}.}
}
\value{
A processed GTAP-formatted dataset with standardized structure and metadata,
ready for analysis or visualization.
}
\description{
Processes GTAP data from \code{sl4} and \code{har} files with options for exporting and preparing plot-ready data.
}
\details{
\itemize{
\item To prepare data for plotting and generating tables within the GTAPViz package, the \code{"Unit"} column must be included in the output.
\item When using the extraction method \code{"group_data_by_dims"}, the corresponding priority list must be defined via the \code{sl4_priority} or \code{har_priority} argument.
See \code{\link[HARplus]{group_data_by_dims}} for more details.
}
}
\examples{
# Input Path:
input_path <- system.file("extdata/in", package = "GTAPViz")

# GTAP Macro Variables from 2 .sl4 Files named (EXP1, EXP2)
# Note: No need to add .sl4 to the experiment name
gtap_data <- auto_gtap_data(experiment = c("EXP1", "EXP2"),
                            har_suffix = "-WEL",
                            input_path = input_path, subtotal_level = FALSE,
                            process_sl4_vars = NULL, process_har_vars = NULL,
                            mapping_info = "GTAPv7", plot_data = TRUE)
}
\seealso{
\code{\link{add_mapping_info}}, \code{\link{convert_units}},
\code{\link{rename_value}}
}
\author{
Pattawee Puangchit
}
