% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gw_nsprcomp.R
\name{gw_nsprcomp}
\alias{gw_nsprcomp}
\title{Geographically Weighted Non-negative Principal Component Analysis}
\usage{
gw_nsprcomp(
  data,
  elocat,
  vars,
  bw,
  k = 2,
  kernel = "gaussian",
  adaptive = TRUE,
  p = 2,
  theta = 0,
  longlat = FALSE,
  geodisic_measure = "cheap",
  dMat = NULL,
  n.obs = NA,
  n.iter = 1,
  ncomp = k,
  nneg = TRUE,
  localcenter = TRUE,
  localscale = FALSE,
  ...
)
}
\arguments{
\item{data}{An sf object containing the spatial data and attributes for analysis}

\item{elocat}{Two-column numeric array or sf object for providing evaluation locations}

\item{vars}{Character vector of variable names to be used in the analysis}

\item{bw}{Bandwidth used in the weighting function}

\item{k}{The number of retained components (default: 2)}

\item{kernel}{Kernel function type: "gaussian", "exponential", "bisquare", "tricube", or "boxcar"}

\item{adaptive}{If TRUE, calculate adaptive kernel (default: TRUE)}

\item{p}{Power of the Minkowski distance (default: 2)}

\item{theta}{Angle in radians to rotate coordinate system (default: 0)}

\item{longlat}{If TRUE, great circle distances will be calculated (default: FALSE)}

\item{geodisic_measure}{Method for geodesic distance calculation (default: "cheap")}

\item{dMat}{Pre-specified distance matrix (default: NULL)}

\item{n.obs}{Number of observations for correlation matrix (default: NA)}

\item{n.iter}{Number of bootstrap iterations (default: 1)}

\item{ncomp}{Number of principal components to compute (default: k)}

\item{nneg}{If TRUE, constrain loadings to be non-negative (default: TRUE)}

\item{localcenter}{If TRUE, center local weighted x (default: TRUE)}

\item{localscale}{If TRUE, scale local weighted x (default: FALSE)}

\item{...}{Additional arguments passed to methods}
}
\value{
A list containing:
\item{loadings}{The localized loadings matrix}
\item{score}{The PC score matrix from the localized non-negative PCA}
\item{sdev}{The localized standard deviation vector of the principal components}
}
\description{
Implementation of geographically weighted non-negative principal component analysis,
which consists of the fusion of GWPCA and sparse non-negative PCA.
}
\examples{
# Read North Carolina SIDS data from sf package
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# Scale selected variables for analysis
vars_to_use <- c("SID74", "NWBIR74", "BIR74")
Data.scaled <- scale(as.matrix(sf::st_drop_geometry(nc[, vars_to_use])))

# Create sf object with scaled data
nc_scaled <- nc
nc_scaled[vars_to_use] <- Data.scaled

gwnnegpca_ans <- gw_nsprcomp(
  data = nc_scaled,
  vars = vars_to_use,
  bw = 0.25,
  k = 3,
  longlat = TRUE,
  kernel = "bisquare",
  adaptive = TRUE,
  nneg = TRUE,
  geodisic_measure = "geodesic"
)
}
