% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_beta.R
\docType{class}
\name{GauPro_kernel_beta}
\alias{GauPro_kernel_beta}
\title{Beta Kernel R6 class}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for fitting GP model.
}
\description{
Beta Kernel R6 class

Beta Kernel R6 class
}
\details{
This is the base structure for a kernel that uses beta = log10(theta)
for the lengthscale parameter.
It standardizes the params because they all use the same underlying
structure.
Kernels that inherit this only need to implement kone and dC_dparams.
}
\examples{
#k1 <- Matern52$new(beta=0)
}
\section{Super class}{
\code{\link[GauPro:GauPro_kernel]{GauPro::GauPro_kernel}} -> \code{GauPro_kernel_beta}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{beta}}{Parameter for correlation. Log of theta.}

\item{\code{beta_est}}{Should beta be estimated?}

\item{\code{beta_lower}}{Lower bound of beta}

\item{\code{beta_upper}}{Upper bound of beta}

\item{\code{beta_length}}{length of beta}

\item{\code{s2}}{variance}

\item{\code{logs2}}{Log of s2}

\item{\code{logs2_lower}}{Lower bound of logs2}

\item{\code{logs2_upper}}{Upper bound of logs2}

\item{\code{s2_est}}{Should s2 be estimated?}

\item{\code{useC}}{Should C code used? Much faster.}

\item{\code{isotropic}}{If isotropic then a single beta/theta is used for all
dimensions. If not (anisotropic) then a separate beta/beta is used for
each dimension.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_beta-new}{\code{GauPro_kernel_beta$new()}}
\item \href{#method-GauPro_kernel_beta-k}{\code{GauPro_kernel_beta$k()}}
\item \href{#method-GauPro_kernel_beta-kone}{\code{GauPro_kernel_beta$kone()}}
\item \href{#method-GauPro_kernel_beta-param_optim_start}{\code{GauPro_kernel_beta$param_optim_start()}}
\item \href{#method-GauPro_kernel_beta-param_optim_start0}{\code{GauPro_kernel_beta$param_optim_start0()}}
\item \href{#method-GauPro_kernel_beta-param_optim_lower}{\code{GauPro_kernel_beta$param_optim_lower()}}
\item \href{#method-GauPro_kernel_beta-param_optim_upper}{\code{GauPro_kernel_beta$param_optim_upper()}}
\item \href{#method-GauPro_kernel_beta-set_params_from_optim}{\code{GauPro_kernel_beta$set_params_from_optim()}}
\item \href{#method-GauPro_kernel_beta-C_dC_dparams}{\code{GauPro_kernel_beta$C_dC_dparams()}}
\item \href{#method-GauPro_kernel_beta-s2_from_params}{\code{GauPro_kernel_beta$s2_from_params()}}
\item \href{#method-GauPro_kernel_beta-clone}{\code{GauPro_kernel_beta$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel" data-id="plot"><a href='../../GauPro/html/GauPro_kernel.html#method-GauPro_kernel-plot'><code>GauPro::GauPro_kernel$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel" data-id="print"><a href='../../GauPro/html/GauPro_kernel.html#method-GauPro_kernel-print'><code>GauPro::GauPro_kernel$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-new}{}}}
\subsection{Method \code{new()}}{
Initialize kernel object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$new(
  beta,
  s2 = 1,
  D,
  beta_lower = -8,
  beta_upper = 6,
  beta_est = TRUE,
  s2_lower = 1e-08,
  s2_upper = 1e+08,
  s2_est = TRUE,
  useC = TRUE,
  isotropic = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta}}{Initial beta value}

\item{\code{s2}}{Initial variance}

\item{\code{D}}{Number of input dimensions of data}

\item{\code{beta_lower}}{Lower bound for beta}

\item{\code{beta_upper}}{Upper bound for beta}

\item{\code{beta_est}}{Should beta be estimated?}

\item{\code{s2_lower}}{Lower bound for s2}

\item{\code{s2_upper}}{Upper bound for s2}

\item{\code{s2_est}}{Should s2 be estimated?}

\item{\code{useC}}{Should C code used? Much faster.}

\item{\code{isotropic}}{If isotropic then a single beta/theta is used for all
dimensions. If not (anisotropic) then a separate beta/beta is used for
each dimension.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-k"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-k}{}}}
\subsection{Method \code{k()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$k(
  x,
  y = NULL,
  beta = self$beta,
  s2 = self$s2,
  params = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector, optional. If excluded, find correlation
of x with itself.}

\item{\code{beta}}{Correlation parameters. Log of theta.}

\item{\code{s2}}{Variance parameter.}

\item{\code{params}}{parameters to use instead of beta and s2.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-kone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-kone}{}}}
\subsection{Method \code{kone()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$kone(x, y, beta, theta, s2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector.}

\item{\code{beta}}{Correlation parameters. Log of theta.}

\item{\code{theta}}{Correlation parameters.}

\item{\code{s2}}{Variance parameter.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-param_optim_start"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-param_optim_start}{}}}
\subsection{Method \code{param_optim_start()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$param_optim_start(
  jitter = F,
  y,
  beta_est = self$beta_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}

\item{\code{beta_est}}{Is beta being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-param_optim_start0"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-param_optim_start0}{}}}
\subsection{Method \code{param_optim_start0()}}{
Starting point for parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$param_optim_start0(
  jitter = F,
  y,
  beta_est = self$beta_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Should there be a jitter?}

\item{\code{y}}{Output}

\item{\code{beta_est}}{Is beta being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-param_optim_lower"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-param_optim_lower}{}}}
\subsection{Method \code{param_optim_lower()}}{
Upper bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$param_optim_lower(
  beta_est = self$beta_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta_est}}{Is beta being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{p_est}}{Is p being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-param_optim_upper"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-param_optim_upper}{}}}
\subsection{Method \code{param_optim_upper()}}{
Upper bounds of parameters for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$param_optim_upper(
  beta_est = self$beta_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{beta_est}}{Is beta being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}

\item{\code{p_est}}{Is p being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-set_params_from_optim"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-set_params_from_optim}{}}}
\subsection{Method \code{set_params_from_optim()}}{
Set parameters from optimization output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$set_params_from_optim(
  optim_out,
  beta_est = self$beta_est,
  s2_est = self$s2_est
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optim_out}}{Output from optimization}

\item{\code{beta_est}}{Is beta being estimated?}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-C_dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-C_dC_dparams}{}}}
\subsection{Method \code{C_dC_dparams()}}{
Calculate covariance matrix and its derivative
 with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$C_dC_dparams(params = NULL, X, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-s2_from_params"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-s2_from_params}{}}}
\subsection{Method \code{s2_from_params()}}{
Get s2 from params vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$s2_from_params(params, s2_est = self$s2_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{parameter vector}

\item{\code{s2_est}}{Is s2 being estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_beta-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_beta-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_kernel_beta$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
