% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BivariateFitter.R
\name{BivariateFitters}
\alias{BivariateFitters}
\alias{BivariateFitter}
\alias{GenBivariateFitter}
\title{Fitter Function for GeD Spline Regression for Bivariate Data}
\usage{
BivariateFitter(
  X,
  Y,
  Z,
  W,
  weights = rep(1, length(X)),
  indicator,
  beta = 0.5,
  phi = 0.99,
  min.intknots = 0L,
  max.intknots = 300L,
  q = 2L,
  Xextr = range(X),
  Yextr = range(Y),
  show.iters = TRUE,
  tol = as.double(1e-12),
  stoptype = c("SR", "RD", "LR"),
  higher_order = TRUE,
  Xintknots = NULL,
  Yintknots = NULL
)

GenBivariateFitter(
  X,
  Y,
  Z,
  W,
  family = family,
  weights = rep(1, length(X)),
  indicator,
  beta = 0.5,
  phi = 0.5,
  min.intknots = 0L,
  max.intknots = 300L,
  q = 2L,
  Xextr = range(X),
  Yextr = range(Y),
  show.iters = TRUE,
  tol = as.double(1e-12),
  stoptype = c("SR", "RD", "LR"),
  higher_order = TRUE
)
}
\arguments{
\item{X}{A numeric vector containing \eqn{N} sample values of the first
independent variable chosen to enter the spline regression component of the
predictor model.}

\item{Y}{A numeric vector containing \eqn{N} sample values of the second
independent variable chosen to enter the spline regression component of the
predictor model.}

\item{Z}{A vector of size \eqn{N} containing the observed values of the
response variable.}

\item{W}{A design matrix with \eqn{N} rows containing other covariates
selected to enter the parametric component of the predictor model (see
\code{\link[=formula.GeDS]{formula}}). If no such covariates are selected, it
is set to \code{NULL} by default.}

\item{weights}{An optional vector of size \eqn{N} of `prior weights' to be
put on the observations in the fitting process in case the user requires
weighted GeDS fitting. It is \code{NULL} by default.}

\item{indicator}{A contingency table (i.e., frequency of observations) for the
independent variables \code{X} and \code{Y}.}

\item{beta}{Numeric parameter in the interval \eqn{[0,1]} tuning the knot
placement in stage A of GeDS. See the description of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{phi}{Numeric parameter in the interval \eqn{(0,1)} specifying the
threshold for the stopping rule  (model selector) in stage A of GeDS. See
also \code{stoptype} and Details in the description of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{min.intknots}{Optional parameter specifying the minimum number of
internal knots required in Stage A's fit. Default is \code{0L}.}

\item{max.intknots}{Optional parameter allowing the user to set a maximum
number of internal knots to be added in Stage A by the GeDS estimation
algorithm. Default equals \code{300L}.}

\item{q}{Numeric parameter which allows to fine-tune the stopping rule of
stage A of GeDS, by default equal to 2. See Details in the description of
\code{\link{NGeDS}} or \code{\link{GGeDS}}.}

\item{Xextr}{Boundary knots in the \code{X} direction. By default equal to
the range of \code{X}.}

\item{Yextr}{Boundary knots in the \code{Y} direction. By default equal to
the range of \code{Y}.}

\item{show.iters}{Logical variable indicating whether or not to print fitting
information at each step. Default is \code{FALSE}.}

\item{tol}{Numeric value indicating the tolerance to be used in checking
whether two knots should be considered different during the knot placement
steps in stage A.}

\item{stoptype}{A character string indicating the type of GeDS stopping rule
to be used. It should be either \code{"SR"}, \code{"RD"} or \code{"LR"},
partial match allowed. See details of \code{\link{NGeDS}} or
\code{\link{GGeDS}}.}

\item{higher_order}{A logical defining whether to compute the higher
order fits (quadratic and cubic) after stage A is run. Default is
\code{TRUE}.}

\item{Xintknots}{A vector of starting internal knots in the \code{X} direction. 
Allows the user to begin Stage A's GeDS algorithm with a linear (least-squares)
spline fit using a predefined vector of internal \code{X} knots, instead of
starting with a straight line fit (i.e., with zero internal knots). Note that
this is not available for \code{GenBivariateFitter}. Default is \code{NULL}.}

\item{Yintknots}{A vector of starting internal knots in the \code{Y} direction. 
Allows the user to begin Stage A's GeDS algorithm with a linear (least-squares)
spline fit using a predefined vector of internal \code{Y} knots, instead of
starting with a straight line fit (i.e., with zero internal knots). Note that
this is not available for \code{GenBivariateFitter}. Default is \code{NULL}.}

\item{family}{A description of the error distribution and link function to be
used in the model. This can be a character string naming a family function
(e.g. \code{"gaussian"}), the family function itself (e.g.
\code{\link[stats]{gaussian}}) or the result of a call to a family function
(e.g. \code{gaussian()}). See \link[stats]{family} for details on family
functions. Note that this argument applies only to \code{GenBivariateFitter}.}
}
\value{
A \code{"GeDS"} class object, but without the \code{formula},
\code{extcall}, \code{terms} and \code{znames} slots.
}
\description{
These are computing engines called by \code{\link{NGeDS}} and
\code{\link{GGeDS}}, needed for the underlying fitting procedures.
}
\references{
Dimitrova, D. S., Kaishev, V. K., Lattuada, A. and Verrall, R. J.  (2023).
Geometrically designed variable knot splines in generalized (non-)linear
models.
\emph{Applied Mathematics and Computation}, \strong{436}. \cr
DOI: \doi{10.1016/j.amc.2022.127493}
}
\seealso{
\code{\link{NGeDS}}, \code{\link{GGeDS}} and \code{\link{UnivariateFitters}}.
}
