% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{predict.GeDS}
\alias{predict.GeDS}
\title{Predict Method for GeDS Objects}
\usage{
\method{predict}{GeDS}(object, newdata, type = c("response", "link", "terms"), n = 3L, ...)
}
\arguments{
\item{object}{The \code{"GeDS"} class object for which the
computation of the predicted values is required.}

\item{newdata}{An optional \code{data.frame}, \code{list} or
\code{environment} containing values of the independent variables for which
predicted values of the predictor model (including the GeDS and the
parametric components) should be computed. If left empty the values are
extracted from the object \code{x} itself.}

\item{type}{Character string specifying the type of prediction to return. The
default is \code{"response"}, which gives predictions on the scale of the
response variable. See Details for other available options.}

\item{n}{Integer value (2, 3 or 4) specifying the order (\eqn{=} degree
\eqn{+ 1}) of the \code{"GeDS"}, \code{"GeDSgam"} or \code{"GeDSboost"}
fit whose predicted values should be computed. By default equal to \code{3L};
non-integer values will be passed to the function \code{\link{as.integer}}.}

\item{...}{Potentially further arguments (required by the definition of the
generic function). They are ignored, but with a warning.}
}
\value{
A numeric vector corresponding to the predicted values (if
\code{type = "link"} or \code{type = "response"}). If \code{type = "terms"}, a
numeric matrix with a column per term.
}
\description{
This is a user friendly method to compute predictions from GeDS objects.
}
\details{
This is a method for the function \code{\link[stats]{predict}} in the
\pkg{stats} package, that allows the user to handle \code{"GeDS"} class objects.

In analogy with the function \code{\link[stats]{predict.glm}} in the
\pkg{stats} package, the user can specify the scale on which the predictions
should be computed through the argument \code{type}. If the predictions are
required to be on the scale of the response variable, the user should set
\code{type = "response"}, which is the default. Alternatively if one wants
the predictions to be on the predictor scale, it is necessary to set
\code{type = "link"}.
By specifying \code{type = "terms"}, it is possible to inspect the predicted
values separately for each single independent variable which enter either the
GeD spline component or the parametric component of the predictor model. In
this case the returned result is a matrix whose columns correspond to the
terms supplied via \code{newdata} or extracted from the \code{object}.

As GeDS objects contain three different fits (linear, quadratic and cubic),
it is possible to specify the order for which GeDS predictions are required
via the input argument \code{n}.
}
\seealso{
\code{\link[stats]{predict}} for the standard definition;
\code{\link{GGeDS}} for examples.
}
