% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R, R/S3methods_GeDSboost-GeDSgam.R
\name{print.GeDS}
\alias{print.GeDS}
\alias{print.GeDSboost}
\alias{print.GeDSgam}
\title{Print Method for GeDS, GeDSgam, GeDSboost}
\usage{
\method{print}{GeDS}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{GeDSgam}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{GeDSboost}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{The \code{"GeDS"}, \code{"GeDSgam"} or \code{"GeDSboost"} class 
object for which the main information should be printed on screen.}

\item{digits}{Number of digits to be printed.}

\item{...}{Potentially further arguments (required by the definition of the
generic function).}
}
\value{
This function returns (invisibly) the same input object, but adding
the slot \code{print} that contains the three sub-slots:
\describe{
\item{Nintknots}{ the number of internal knots of the linear
GeDS/FGB-GeDS/GAM-GeDS fit}
\item{deviances}{ the deviances of the three (linear, quadratic and cubic)
GeDS/FGB-GeDS/GAM-GeDS fits}
\item{call}{ the \code{call} to the function that produced the \code{x}
object}
}
}
\description{
Method for the generic function \code{\link[base]{print}} that allows to
print on screen the main information related to a fitted \code{"GeDS"},
\code{"GeDSgam"}, \code{"GeDSboost"} class model.
}
\details{
This method allows to print on screen basic information related to the fitted
predictor model such as the function \code{call}, the number of internal
knots for the linear GeDS/FGB-GeDS/GAM-GeDS fit and the deviances for the
three (linear, quadratic and cubic) fitted predictor models embedded in the
\code{"GeDS"}, \code{"GeDSgam"} or \code{"GeDSboost"} object.
}
\seealso{
\code{\link[base]{print}} for the standard definition.
}
