% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmcx.R
\name{mmcx}
\alias{mmcx}
\title{Non-homogeneous Multivariate Markov Chains}
\usage{
mmcx(y, x, initial, ...)
}
\arguments{
\item{y}{matrix of categorical data sequences}

\item{x}{matrix of covariates}

\item{initial}{numerical vector of initial values.}

\item{...}{additional arguments to be passed down to \code{\link[alabama:auglag]{auglag()}}.}
}
\value{
The function returns a list with the parameter estimates, standard-errors, z-statistics, p-values and the value of the log-likelihood function, for each equation.
}
\description{
Estimates Multivariate Markov Chains that depend on a exogeneous variables.
The model is based on the Mixture Transition Distribution model, and considers non-homogeneous Markov Chains, instead of homogeneous Markov Chains as in Raftery (1985).
}
\examples{
data(stockreturns)
s <- cbind(stockreturns$sp500, stockreturns$djia)
x <- stockreturns$spread_1
mmcx(s, x, initial = c(1, 1))

}
\references{
Raftery, A. E. (1985). A Model for High-Order Markov Chains. Journal of the Royal Statistical Society. Series B (Methodological), 47(3), 528-539. \url{http://www.jstor.org/stable/2345788}

Ching, W. K., E. S. Fung, and M. K. Ng (2002). A multivariate Markov chain model for categorical data sequences and its applications in demand predictions. IMA Journal of Management Mathematics, 13(3), 187-199. \doi{10.1093/imaman/13.3.187}
}
\seealso{
Optimization is done through \code{\link[alabama:auglag]{auglag()}}.
}
\author{
Carolina Vasconcelos and Bruno Damásio
}
