% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateModel.R
\name{estimateModel}
\alias{estimateModel}
\title{Estimates model parameters}
\usage{
estimateModel(
  data = NULL,
  options = NULL,
  priors = NULL,
  n.sims = NULL,
  log_tau = NULL,
  log_kappa = NULL,
  USpatial = 1,
  alphaSpatial = 0.05,
  UNugget = 1,
  alphaNug = 0.05
)
}
\arguments{
\item{data}{A data input list that is created by prepareInput() function.}

\item{options}{A list containing two components, namely, random and covariates.
The function accounts for jittering both in the spatial random effect and in
covariates (if there are any) by default. However, the jittering adjustment
can be turned off in either the random effect or in covariates, or both, by
setting the corresponding component of the list to zero.}

\item{priors}{A list of two components. Beta is a vector of two elements and
passes the parameters of the Gaussian prior that will be assigned to the covariates
(including the intercept). The first element of it is the mean and the second
one is the standard deviation of Gaussian prior. Range is a value representing
the median range in kilometers, which will be used for constructing the
PC (Penalized-complexity) priors.}

\item{n.sims}{number of samples to be drawn for each model parameter}

\item{log_tau}{SPDE parameter related to the spatial precision}

\item{log_kappa}{SPDE parameter related to the range and spatial precision}

\item{USpatial}{The threshold that is crossed by the the variance prior.}

\item{alphaSpatial}{The probability of crossing the threshold for the variance prior.}

\item{UNugget}{The threshold that is crossed by the prior on the nugget standard
deviation. It will only be used when the likelihood is Gaussian.}

\item{alphaNug}{The probability  of crossing the threshold for the
prior on the nugget standard deviation. It will only be used when the likelihood
is Gaussian.}
}
\value{
Model estimation results of class GAmodel. The output consists of four
elements: A data frame containing the estimated model parameters and the
corresponding 95% credible interval lengths, the optimized core model object
from autodifferentiation of TMB, A matrix containing the sampled coefficient
effect sizes and the random effect coefficients, A character string indicating
the likelihood type in the model.
}
\description{
Estimates model parameters
}
\examples{
\donttest{
path1 <- system.file("extdata", "exampleInputData.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "exampleMesh.rda", package = "GeoAdjust")
load(path1)
load(path2)
results <- estimateModel(data = exampleInputData, priors = list(beta = c(0,1),
range = 114), USpatial = 1, alphaSpatial = 0.05, UNugget = 1, alphaNug = 0.05, n.sims = 1000)
}
}
