% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_test.R
\name{add_significance0}
\alias{add_significance0}
\title{Add P-value Significance Symbols}
\usage{
add_significance0(data, p.col = NULL, output.col = NULL)
}
\arguments{
\item{data}{a data frame containing a p-value column.}

\item{p.col}{column name containing p-values.}

\item{output.col}{the output column name to hold the adjusted p-values.}
}
\value{
a data frame
}
\description{
Redefine the default parameters of \code{rstatix::add_significance()}
by adding p-value significance symbols to a data frame.
}
\examples{
library(magrittr)
library(rstatix, warn.conflicts = FALSE)
data("ToothGrowth")
ToothGrowth \%>\%
    t_test(len ~ dose) \%>\%
    adjust_pvalue() \%>\%
    add_significance0("p.adj")

}
