% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcor_test.R
\name{mcor_test}
\alias{mcor_test}
\title{Multiple correlation test}
\usage{
mcor_test(
  x,
  y = NULL,
  estimate = TRUE,
  p.value = FALSE,
  method = "spearman",
  method_adjust = "BH"
)
}
\arguments{
\item{x}{Data frame containing numerical variables.}

\item{y}{Data frame containing numerical variables. If \code{NULL}, correlations are calculated within \code{x}.}

\item{estimate}{Logical specifying whether to return correlation coefficients.}

\item{p.value}{Logical specifying whether to return adjusted p-values.}

\item{method}{Character specifying the correlation method: \code{pearson}, \code{kendall}, or \code{spearman}.}

\item{method_adjust}{Character specifying the p-value adjustment method.}
}
\value{
Depending on the values of \code{estimate} and \code{p.value}, one of the following:
\describe{
\item{estimate = TRUE, p.value = FALSE}{A numeric matrix of correlation
coefficients, with columns corresponding to variables in \code{x} and rows
to variables in \code{y}.}
\item{estimate = FALSE, p.value = TRUE}{A numeric matrix of adjusted p-values,
with columns corresponding to variables in \code{x} and rows to variables in
\code{y}.}
\item{estimate = TRUE, p.value = TRUE}{A named list with two elements:
\describe{
\item{estimate}{Numeric matrix of correlation coefficients.}
\item{p.value}{Numeric matrix of adjusted p-values.}
}
}
}
}
\description{
Calculates correlations between multiple variables.
}
\examples{
library(magrittr)
x0 <- runif(20)
x <- lapply(
    c(1, -1),
    function(i) sapply(seq(10), function(j) x0 * i + runif(10, max = 1))
) \%>\%
    Reduce(cbind, .) \%>\%
    set_colnames(paste("Variable", seq(20)))
y <- lapply(
    c(1, -1),
    function(i) sapply(seq(10), function(j) x0 * i + runif(10, max = 1))
) \%>\%
    Reduce(cbind, .) \%>\%
    set_colnames(paste("Variable", seq(20))) \%>\%
    .[, seq(5)]
mcor_test(x)
mcor_test(
    x,
    y,
    p.value = TRUE,
    method = "pearson",
    method_adjust = "bonferroni"
)

}
