% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_summary.R
\name{get_dim_patterns}
\alias{get_dim_patterns}
\title{Get Dimension Patterns from SL4 and HAR Objects}
\usage{
get_dim_patterns(..., keep_unique = FALSE)
}
\arguments{
\item{...}{One or more structured SL4 or HAR objects containing dimension information.}

\item{keep_unique}{Logical. If \code{TRUE}, returns only unique dimension patterns. Default is \code{FALSE}.}
}
\value{
A data frame containing:
\itemize{
\item \code{DimPattern}: The unique dimension patterns.
}
}
\description{
Extracts and lists unique dimension patterns (e.g., \code{REG*COMM}, \code{REG*REG*ACTS}) from one or more datasets.
}
\details{
\itemize{
\item Extracts dimension structure details from the dataset.
\item If multiple datasets are provided, combines their dimension information.
\item If \code{keep_unique = TRUE}, returns only distinct dimension patterns.
}
}
\examples{
# Import sample data:
sl4_data <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))
sl4_data2 <- load_sl4x(system.file("extdata", "SUBT10.sl4", package = "HARplus"))

# Extract dimension patterns
get_dim_patterns(sl4_data)

# Extract only unique dimension patterns across datasets
get_dim_patterns(sl4_data, sl4_data2, keep_unique = TRUE)

}
\seealso{
\code{\link{get_dim_elements}}, \code{\link{get_var_structure}}
}
\author{
Pattawee Puangchit
}
