% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shock_cal.R
\name{shock_calculate_uniform}
\alias{shock_calculate_uniform}
\title{Calculate Shocks with Uniform Adjustment}
\usage{
shock_calculate_uniform(
  initial_config,
  adjustment_value,
  calculation_method = "*",
  calc_config,
  output_path,
  long_desc = "Uniform shock adjustment",
  dim_order = NULL,
  lowercase = FALSE
)
}
\arguments{
\item{initial_config}{A list created by \code{\link{create_initial_config}}, defining:
\itemize{
\item Input file path, format, and variable header
\item Column name for initial rate values ("Value_ini")
}}

\item{adjustment_value}{Numeric scalar specifying the uniform adjustment to apply.
\itemize{
\item Interpreted according to \code{calculation_method}
\item For example, 0.5 with method "*" halves the base rate
}}

\item{calculation_method}{Operator defining the adjustment method:
\itemize{
\item "*" multiply (default)
\item "/" divide
\item "+" add
\item "-" subtract
}}

\item{calc_config}{A list created by \code{\link{create_calc_config}}, specifying:
\itemize{
\item \code{timeline}: sequence of simulation periods (e.g., "1-10")
\item \code{exclude_self_trade}: logical, whether to omit intra-region pairs
\item \code{exclusion_values}: optional list defining excluded elements
}}

\item{output_path}{Path to the output HAR file where calculated shocks will be written.}

\item{long_desc}{Optional text for header description. Default is "Uniform shock adjustment".}

\item{dim_order}{Optional dimension ordering specification. Can be:
\itemize{
\item NULL (default): alphabetical A-Z ordering
\item a named list defining preferred order per dimension
\item a data frame or path to Excel/CSV with explicit order definitions
}}

\item{lowercase}{Logical; if TRUE, converts all dimension elements to lowercase. Default is FALSE.}
}
\value{
Invisibly returns a list containing summary metadata:
\itemize{
\item \code{n_observations}: total records processed
\item \code{n_included}: records included in shock computation
\item \code{n_excluded}: records excluded by configuration
\item \code{output_path}: normalized path to the generated HAR file
}
}
\description{
Generates GEMPACK-style percentage shocks using a uniform proportional adjustment
applied to all values in the initial dataset. The function supports additive or
multiplicative adjustments, single or multi-period configurations, and direct HAR export.
}
\details{
\itemize{
\item Applies uniform adjustment to all base rates across defined dimensions
\item Supports additive ("+", "-") and proportional ("*", "/") adjustments
\item Computes compounded shocks following the "power of tax" formulation
\item Handles multiple time periods as defined by \code{timeline} in \code{calc_config}
\item Excludes self-trade or specified region/sector pairs if configured
\item Outputs results as multi-header HAR file (one per timeline period)
}
}
\examples{
# Example 1: Uniform Shock (50\% Reduction)
har_path <- system.file("extdata", "baserate.har", package = "HARplus")

# Sorting Column
mapping <- list(
  REG = c("USA", "EU", "ROW")
)

# Initial File
initial <- create_initial_config(
  path   = har_path,
  format = "har",
  header = "rTMS"
)

# Calculation Setup
calc <- create_calc_config(
  timeline           = "1-10",
  exclude_self_trade = TRUE
)

# Compute Uniform 50\% Reduction (Value_tar = Value_ini * 0.5)
shock_calculate_uniform(
  initial_config     = initial,
  adjustment_value   = 0.5,
  calculation_method = "*",
  calc_config        = calc,
  output_path        = file.path(tempdir(), "output_uniform.har"),
  dim_order          = mapping
)
}
\seealso{
\code{\link{shock_calculate}}, \code{\link{create_initial_config}},
\code{\link{create_calc_config}}, \code{\link{save_har}}
}
\author{
Pattawee Puangchit
}
