% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDgen.R
\name{IBDgen}
\alias{IBDgen}
\title{Generating Incomplete Block Designs}
\usage{
IBDgen(K, n.trt, t, n.vec = NULL, L = NULL, l = NULL, W = NULL, balanced = T)
}
\arguments{
\item{K}{The number of blocks.}

\item{n.trt}{The number of whole treatments.}

\item{t}{The number of treatments to be assigned to each block.}

\item{n.vec}{The vector of block sizes.}

\item{L}{The vector of the number of blocks having each treatment.}

\item{l}{The matrix of the number of blocks having each pair of treatments.}

\item{W}{The set of treatment subsets used in the design.}

\item{balanced}{Whether the design is balanced or not. If \code{TRUE}, generate a balanced design.}
}
\value{
A list containing the following components:
\item{W}{The set of treatment subsets used in the design.}
\item{W.uniq}{The unique set of treatment subsets used in the design with proportion in \code{W}.}
\item{Rk}{The block assignment matrix.}
\item{blk_assign}{The block assignment data frame.}
}
\description{
Generate incomplete block designs.
}
\examples{
K <- 6
n.trt <- 3
t <- 2
n.vec <- rep(4, K)
IBDgen(K = K, n.trt = n.trt, t = t, n.vec = n.vec)

}
\references{
{
Sailer, M. O., & Bornkamp, M. B. (2022). Package ‘crossdes’: Construction of Crossover Designs.
}
}
