% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{fitted.ICS-S3}
\alias{fitted.ICS-S3}
\alias{fitted.ICS}
\title{Fitted Values of the ICS Transformation}
\usage{
\method{fitted}{ICS}(object, select = NULL, index = NULL, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"ICS"} containing
results from an ICS transformation.}

\item{select}{an integer, character, or logical vector specifying which
components to use for computing the fitted values, or \code{NULL} to compute
the fitted values from all components.}

\item{index}{an integer vector specifying which components to use for
computing the fitted values, or \code{NULL} to compute the fitted values
from all components.  Note that \code{index} is deprecated and may be
removed in the future, use \code{select} instead.}

\item{\dots}{additional arguments are ignored.}
}
\value{
A numeric matrix containing the fitted values.
}
\description{
Computes the fitted values based on an invariant coordinate system obtained
via an ICS transformation.  When using all components, computing the fitted
values constitutes a backtransformation to the observed data.  When using
fewer components, the fitted values can often be viewed as reconstructions
of the observed data with noise removed.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
fitted(out)
fitted(out, select = 4)

}
\seealso{
\code{\link{ICS}()}

\code{\link{gen_kurtosis}()}, \code{\link[=coef.ICS]{coef}()},
\code{\link{components}()}, and \code{\link[=plot.ICS]{plot}()}
methods
}
\author{
Andreas Alfons and Aurore Archimbaud
}
