% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individualized-Dynamic-Latent-Factor-Model.R
\name{IDLFM}
\alias{IDLFM}
\title{Individualized Dynamic Latent Factor Model}
\usage{
IDLFM(
  X,
  Y,
  n_patients,
  n_var,
  time,
  idx_x,
  idx_y,
  rank,
  k,
  N,
  lambda1 = 1,
  lambda2 = 1,
  Niter = 100,
  alpha = 0.001,
  ebs = 1e-04,
  l = 1,
  verbose
)
}
\arguments{
\item{X}{a sparse matrix for predictor variables}

\item{Y}{a sparse matrix for response variables}

\item{n_patients}{the number of patients}

\item{n_var}{the number of X variables}

\item{time}{maximum time}

\item{idx_x}{indices for the X data, a sparse matrix}

\item{idx_y}{indices for the Y data, a sparse matrix}

\item{rank}{rank for the random matrices}

\item{k}{spline smoothness}

\item{N}{number of knots in the spline}

\item{lambda1}{regularization parameter for fused lasso, with the default value 1}

\item{lambda2}{regularization parameter for total variation, with the default value 1}

\item{Niter}{number of iterations for the Adam optimizer, with the default value 100}

\item{alpha}{learning rate for the Adam optimizer, with the default value 0.001}

\item{ebs}{convergence threshold, with the default value 0.0001}

\item{l}{regularization parameter, with the default value 1}

\item{verbose}{to control the console output}
}
\value{
A list is returned, containing the model weights, factor matrix, spline knots, predicted X and Y.
}
\description{
This function implements the individualized dynamic latent factor model.
}
\examples{
library(splines)
#if (!require("BiocManager", quietly = TRUE))
#install.packages("BiocManager")
#BiocManager::install("SparseArray")
library(SparseArray)

I <- 3
J <- 5
time <- 1000
R <- 3
k <- 3
N <- 300
idx_x <- randomSparseArray(c(I, J, time), density=0.8)
idx_y_train <- randomSparseArray(c(I, 1, time), density=0.2)
idx_y_test <- randomSparseArray(c(I, 1, time), density=0.2)
data <- generate_data(I, J, time, idx_x, idx_y_train, R, k, N)
output_x <- data[[1]]
output_y <- data[[2]]
knots <- data[[3]]
weights <- data[[4]]
Fx <- data[[5]]
Fy <- data[[6]]
IDLFM(X = output_x, Y = output_y, n_patients = I, n_var = J, time = time,
idx_x = idx_x, idx_y = idx_y_train, rank = R, k = k, N = N, verbose = FALSE)
}
\references{
Zhang, J., F. Xue, Q. Xu, J. Lee, and A. Qu. "Individualized dynamic latent factor model for multi-resolutional data with application to mobile health." Biometrika (2024): asae015.
}
