% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHeatmap.R
\name{PlotHeatmap}
\alias{PlotHeatmap}
\title{PlotHeatmap}
\usage{
PlotHeatmap(MiRNA_CRData,yaxis=c(-2,2),scale="row",
cluster.rows=FALSE,cluster.cols=FALSE,show.colnames=FALSE,
ann_colors=c("#ef6d6d","#5470c6"),col=c("#ef6d6d","#5470c6"))
}
\arguments{
\item{MiRNA_CRData}{A list includes a data frame with seven parts those are "sample", "status", "time", "target genes expression", "risk score", "group", and a data frame with five columns those are "Gene", "HR", "HR.95L", "HR.95H", "beta", and "P-value".}

\item{yaxis}{The upper and lower limits of this heat map.}

\item{scale}{character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row", "column" and "none".}

\item{cluster.rows}{A logical value that represents whether row clustering is used.}

\item{cluster.cols}{A logical value that represents whether col clustering is used.}

\item{show.colnames}{This parameter controls whether column names are displayed.}

\item{ann_colors}{Vector of colors used to define groups.}

\item{col}{Vector of colors used in the heatmap.}
}
\value{
A heat map of miRNA targets expression.
}
\description{
The function "PlotHeatmap" is used to plot a heat map of miRNA targets expression.
}
\examples{
# Obtain the example data
GEP<-GetData_Mirna("GEP")
survival<-GetData_Mirna("survival")
MiRNAs<-c("hsa-miR-21-5p","hsa-miR-26a-5p","hsa-miR-369-5p","hsa-miR-1238-3p","hsa-miR-10b-5p")
# Run the function
SingleMiRNA_CRData<-SingleMiRNA_CRModel(GEP,
"hsa-miR-21-5p",survival,cutoff.point=NULL)
PlotHeatmap(SingleMiRNA_CRData)
MutiMiRNA_CRData<-MutiMiRNA_CRModel(GEP,
MiRNAs,survival,cutoff.point=NULL)
PlotHeatmap(MutiMiRNA_CRData)
}
