% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_functions.R
\name{LR_cp}
\alias{LR_cp}
\title{Function to compute Left risk measure.}
\usage{
LR_cp(data, FT, ov)
}
\arguments{
\item{data}{A (T x N) matrix or data.frame containing the N time series over period T}

\item{FT}{Window size.}

\item{ov}{umber of different days for two consecutive time windows.}
}
\value{
A (N x T) data.frame containing the LR_cp measure for the N time series over time windows
}
\description{
Function to compute Left risk measure.
}
\examples{

\donttest{
LR <- LR_cp(sample.data, FT= 1290, ov = 125)
df <- as.data.frame(matrix(unlist(LR), nrow = length(LR), ncol = ncol(sample.data)))
colnames(df) <- c(paste("tw", rep(1:16)))
plot(df[,1], pch=19, col=asset.label$label, ylab="LR_cp", xlab="ETFs")
}

}
