% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\alias{compare,INLAvaan-method}
\alias{compare,INLAvaan-class}
\title{Compare Bayesian Models Fitted with INLAvaan}
\usage{
compare(x, y, ...)

\S4method{compare}{INLAvaan}(x, y, ...)
}
\arguments{
\item{x, y, ...}{An object of class \code{INLAvaan} or \code{inlavaan_internal}.}
}
\value{
A data frame of class \code{compare.inlavaan_internal} containing model
fit statistics.
}
\description{
Compare Bayesian Models Fitted with INLAvaan
}
\details{
The function computes the log Bayes Factor (logBF) relative to the best
fitting model (the one with the highest Marginal Log-Likelihood).

The output table sorts models by descending Marginal Log-Likelihood.
\itemize{
\item \strong{Marg.Loglik}: The approximated marginal log-likelihood.
\item \strong{DIC}: Deviance Information Criterion (if available).
\item \strong{pD}: Effective number of parameters (if available).
\item \strong{logBF}: The natural logarithm of the Bayes Factor relative to the best model.
}
}
\examples{
\donttest{
# Model comparison on multigroup analysis (measurement invariance)
HS.model <- "
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
"
utils::data("HolzingerSwineford1939", package = "lavaan")

# Configural invariance
fit1 <- acfa(HS.model, data = HolzingerSwineford1939, group = "school")

# Weak invariance
fit2 <- acfa(
  HS.model,
  data = HolzingerSwineford1939,
  group = "school",
  group.equal = "loadings"
)

# Strong invariance
fit3 <- acfa(
  HS.model,
  data = HolzingerSwineford1939,
  group = "school",
  group.equal = c("intercepts", "loadings")
)

# Compare models
compare(fit1, fit2, fit3)
}
}
\references{
https://lavaan.ugent.be/tutorial/groups.html
}
