% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusINet.R
\name{consensusNet}
\alias{consensusNet}
\title{consensusNet}
\usage{
consensusNet(
  adjL,
  threshold = 0.5,
  tolerance = 0.1,
  theta = 0.04,
  nitermax = 50,
  ncores = 2,
  verbose = TRUE
)
}
\arguments{
\item{adjL}{list of weighted adjacency matrix with the same name in rows
and columns for all the matrices.}

\item{threshold}{threshold for the construction of the Consensus
(default 0.5). Used in the last step on the similar graphs.}

\item{tolerance}{the tolerance of differences between similar graphs for the
construction of the Consensus (default 0.1).}

\item{theta}{importance to give to the neighbourhood part of the weight
(default 0.04).}

\item{nitermax}{maximum number of iteration before stopping the algorithm
(default 50).}

\item{ncores}{number of CPU cores to use (default is 2). We suggest to use
ncores equal to the number of graphs to integrate.}

\item{verbose}{flag for verbose output (default as TRUE).}
}
\value{
a list of 3 types:
$graphConsensus the Consensus Network,
$Comparison the Jaccard weighted distances between the graphs
calculated in each iteration,
$similarGraphs the similar graphs before the Thresholding
}
\description{
This function computes the INet Algorithm for the construction of a
**Consensus Network**.
}
\examples{
data("adjL_data")
consensusNet(adjL_data)
}
