% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_True_Win_Probability.R
\name{Get_True_Win_Probability}
\alias{Get_True_Win_Probability}
\title{Gives the true win probability, mean ventilator days, and advanced respiratory days for a set of simulation parameters.}
\usage{
Get_True_Win_Probability(
  Prob_Death,
  P_Vent_28,
  P_Vent_0,
  CONTROL_VENT_DENSITY_NON_0_28,
  P_ADVANCED_0_NO_VENT,
  CONTROL_ADVANCED_DISTRIBUTION_NO_VENT,
  P_ADVANCED_0_VENT,
  CONTROL_ADVANCED_DISTRIBUTION_VENT,
  Prob_Death_Treatment,
  P_Vent_28_Treatment,
  P_Vent_0_Treatment,
  CHANGE_MEAN_VENTILATION_TREATMENT,
  P_ADVANCED_0_NO_VENT_Treatment,
  CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT,
  P_ADVANCED_0_VENT_Treatment,
  CHANGE_MEAN_ADVANCED_TREATMENT_VENT
)
}
\arguments{
\item{Prob_Death}{Probability of death within 28 days for control patients.}

\item{P_Vent_28}{Probability of being ventilated for 28 days or more in control participants who do not die in 28 days.}

\item{P_Vent_0}{Probability of being ventilated for 0 days in control participants who do not die in 28 days.}

\item{CONTROL_VENT_DENSITY_NON_0_28}{Nonparametric density estimate of ventilator days between 1 and 27 days for control participants who do not die in 28 days.}

\item{P_ADVANCED_0_NO_VENT}{Probability of 0 advanced respiratory days in control participants who did not die in 28 days and are never ventilated.}

\item{CONTROL_ADVANCED_DISTRIBUTION_NO_VENT}{Nonparametric density estimate of advanced respiratory days between 1 and 28 days for control participants who do not die in 28 days and are never ventilated.}

\item{P_ADVANCED_0_VENT}{Probability of 0 advanced respiratory days in control participants who did not die in 28 days and are ventilated.}

\item{CONTROL_ADVANCED_DISTRIBUTION_VENT}{Nonparametric density estimate of advanced respiratory days between 1 and 28 days for control participants who do not die in 28 days and are never ventilated.}

\item{Prob_Death_Treatment}{Probability of death within 28 days for treatment patients.}

\item{P_Vent_28_Treatment}{Probability of being ventilated for 28 days or more in treatment participants who do not die in 28 days.}

\item{P_Vent_0_Treatment}{Probability of being ventilated for 0 days in treatment participants who do not die in 28 days.}

\item{CHANGE_MEAN_VENTILATION_TREATMENT}{Shift in the nonparametric density estimate of ventilator days between 1 and 27 for treatment patients relative to controls in those who did not die in 28 days.}

\item{P_ADVANCED_0_NO_VENT_Treatment}{Probability of 0 advanced respiratory days in treatment participants who did not die in 28 days and are never ventilated.}

\item{CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT}{Shift in the nonparametric density estimate of advanced respiratory days between 1 and 28 for treatment patients relative to controls in those who do not die in 28 days and are never ventilated.}

\item{P_ADVANCED_0_VENT_Treatment}{Probability of 0 advanced respiratory days in treatment participants who did not die in 28 days and are ventilated.}

\item{CHANGE_MEAN_ADVANCED_TREATMENT_VENT}{Shift in the nonparametric density estimate of advanced respiratory days between 1 and 28 for treatment patients relative to controls in those who do not die in 28 days and are ventilated.}
}
\value{
A vector containing the true win probability of a scenario. It also returns the implied mean ventilator days in treatment and control participants and the implied mean advanced respiratory days.
}
\description{
Gives the true win probability, mean ventilator days, and advanced respiratory days for a set of simulation parameters.
}
\examples{
##Load in the nonparametric densities
##load("Control_Ventilator_Non0_28_Density.rda")
##load("Control_Advanced_Distribution_No_Ventilated.rda")
##load("Control_Advanced_Distribution_Ventilated.rda")
library(DFBA)
###Control Parameters
Prob_Death=.25
P_Vent_0 = .48
P_Vent_28 = .05
P_ADVANCED_0_NO_VENT = .31
P_ADVANCED_0_VENT = .62
###Treatment Parameters
Prob_Death_Treatment = Prob_Death-.05
P_Vent_28_Treatment = P_Vent_28-.01
P_Vent_0_Treatment = P_Vent_0 + .1
CHANGE_MEAN_VENTILATION_TREATMENT = -2
P_ADVANCED_0_NO_VENT_Treatment = P_ADVANCED_0_NO_VENT + .1
CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT = -2
P_ADVANCED_0_VENT_Treatment = P_ADVANCED_0_VENT + .1
CHANGE_MEAN_ADVANCED_TREATMENT_VENT = -2
Get_True_Win_Probability(Prob_Death,P_Vent_28,P_Vent_0,CONTROL_VENT_DENSITY_NON_0_28,
P_ADVANCED_0_NO_VENT,CONTROL_ADVANCED_DISTRIBUTION_NO_VENT,
P_ADVANCED_0_VENT,CONTROL_ADVANCED_DISTRIBUTION_VENT,
Prob_Death_Treatment,P_Vent_28_Treatment,P_Vent_0_Treatment,CHANGE_MEAN_VENTILATION_TREATMENT,
P_ADVANCED_0_NO_VENT_Treatment,CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT,
P_ADVANCED_0_VENT_Treatment,CHANGE_MEAN_ADVANCED_TREATMENT_VENT)
}
