% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jnt_cat.R
\name{jnt_cat}
\alias{jnt_cat}
\title{Calculation and visualization of regions of non-significance to assess the
influence of categorical moderators}
\usage{
jnt_cat(
  X,
  Y,
  m,
  data,
  alpha.sig = 0.05,
  plot.full = FALSE,
  correlation = NULL,
  cols = c("black", "black"),
  pch = c(16, 1),
  cex = 1,
  xlab = X,
  ylab = Y,
  lty = c(1, 2),
  line.col = c("black", "black"),
  lwd = c(1, 1),
  legend = TRUE
)
}
\arguments{
\item{X}{A character string defining the name of the covariate (e.g., size in
an allometry analysis). Must be the same as the name of the variable in the
dataset (see argument “data”).}

\item{Y}{A character string defining the name of the dependent variable. Must
be the same as the name of the variable in the dataset (see argument “data”).}

\item{m}{A character string defining the name of a categorical moderator
(e.g., males and females, herbivorous and carnivorous, etc). Must be the same
as the name of the variable in the dataset (see argument “data”). The
variable must have two levels.}

\item{data}{A dataframe containing the variables in the model.}

\item{alpha.sig}{A value representing the significance value (alpha) to be considered.}

\item{plot.full}{A logical. It indicates whether the plot should show the
JN non-significance regions even if they don’t or just partially overlap the data.
The default option is 'FALSE', meaning that the plot limits will depend only on the range of predictor values}

\item{correlation}{an optional corStruct object describing the within-group
correlation structure. See the documentation of \link[nlme]{corClasses} for a description of
the available corStruct classes. If a grouping variable is to be used, it must be
specified in the form argument to the corStruct constructor. Defaults to NULL,
corresponding to uncorrelated errors.}

\item{cols}{A vector of strings defining the colors of the symbols to be used in the
plot. By default, c('black', 'black') is used, which combines with the default
in the argument 'pch' to present two groups of datapoints as open and close.}

\item{pch}{A vector of strings defining the symbols to be used to represent
distinct groups in the plot. Use same symbol codes as in the argument 'pch'
in the R base function 'plot'. By default, c(16, 1) is used, which combines
with the default in the argument 'cols' to present two groups of datapoints
as open and close.}

\item{cex}{number indicating the amount by which plotting symbols should
be scaled relative to the default (1).}

\item{xlab}{A title for the X axis. Defaults to the name of the predictor variable
in the data.}

\item{ylab}{A title for the Y axis. Defaults to the name of the dependent variable
in the data.}

\item{lty}{A vector defining the line type of the regression lines for each category.
Defaults to c(1,2).}

\item{line.col}{A vector of strings defining the line colors of the regression lines for each category.
Defaults to c('black','black').}

\item{lwd}{A vector defining the line width of the regression lines for each category.
Defaults to c(1,1).}

\item{legend}{A logical indicating whether a legend should appear on top of the plot. Defaults to 'TRUE'.}
}
\value{
List with four elements: (1) results from the linear model, (2) lower and
(3) upper limits of non-significance in the predictor, and (4) a graphical output.
}
\description{
Produces a plot showing regions of non-significance defined by predictor values
for which no significant differences in the dependent variable are found
between categories.
}
\examples{
data(microlophus)
jnt_cat(X='svl', Y='hl', m='species', data=microlophus,
xlab='log(SVL)', ylab='log(head length)')
}
\references{
Toyama, K. S. (2024). JNplots: an R package to visualize outputs
from the Johnson-Neyman technique for categorical and continuous moderators,
including options for phylogenetic regressions. Evolutionary Ecology 38: 371–385.
}
