% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLR.R
\name{logLR}
\alias{logLR}
\title{CLR for a single case}
\usage{
logLR(
  AB,
  afmatrix = NULL,
  rare = 1e-04,
  allelename = FALSE,
  stepPI = FALSE,
  adelta3 = NULL,
  adelta9 = NULL,
  mu = 0.002
)
}
\arguments{
\item{AB}{Genotypes of two individuals in a case, which should be data.frame with 4 columns (2 for each individual) and \code{nl} rows, where \code{nl} stand for number of loci. The row names should be the name of each locus;}

\item{afmatrix}{name of allele frequency list, which can be loaded with "EvaluatePanel" function}

\item{rare}{a data frame containing the frequency of rare allele on the locus, with 1 row and multiple columns, each column for a marker;}

\item{allelename}{if TRUE, the input genotype data would be regarded as allelenames, otherwise, the position in the afmatrix}

\item{stepPI}{If TRUE, empirical decreasing model of STR mutation would be taken when paternity index is needed to be calculated, otherwise, mutation rate would be taken as PI if IBS=0 between an alleged PC pair.}

\item{adelta3}{distributions of the IBD coefficient of the outbred plaintiff's hypotheses in LR calculation, which should be a data.frame with 3 columns and x rows, where x stood for the number of such LR being calculated. The names of columns should be "k0", "k1" and "k2", and those of rows the name of LRs}

\item{adelta9}{distributions of the Jacquard coefficient of the inbred plaintiff's hypotheses in LR calculation, which should be a data.frame with 9 columns and x rows, where x stood for the number of such LR being calculated. The names of columns should be "D1-D9", and those of rows the name of LRs}

\item{mu}{mutation rate when paternity index is needed to be calculated, defualts to 0.002.}
}
\value{
a list of two data.frames: (i) results_on_each_marker: multiple types of parameters calculated on each marker, including IBS and multiple log10 of LRs; (ii) total_results_of_the _case: the CIBS and log10CLR results for the whole case.
}
\description{
CLR calculation for a single case, where two individual participated and labeled as A and B
}
\examples{
# example code
AB<-data.frame(a=rep(0,42),b=rep(0,42),c=rep(0,42),d=rep(0,42))
for (i in 1:42) {
temp<-pairsimu(af = FortytwoSTR$afmatrix[[i]],ss = 1,delta = c(0,1,0),allelename = FALSE)
AB[i,]=temp
rownames(AB)[i]=names(FortytwoSTR$afmatrix)[i]
}
adelta3<-data.frame(k0=c(0,0.25,0.5),k1=c(1,0.5,0.5),k2=c(0,0.25,0),row.names = c("PC","FS","HS"))
adelta9<-data.frame(D1=0,D2=0,D3=0,D4=0,D5=0.25,D6=0,D7=0.25,D8=0.5,D9=0,row.names = "FIMCpair")
results<-logLR(AB=AB,afmatrix=FortytwoSTR$afmatrix,rare=FortytwoSTR$rare,stepPI=TRUE,
adelta3=adelta3,adelta9=adelta9)
results$total_results_of_the_case
}
