% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_functions.R
\name{plot.lbbnn_net}
\alias{plot.lbbnn_net}
\title{Plot \code{lbbnn_net} objects}
\usage{
\method{plot}{lbbnn_net}(x, type = c("global", "local"), data = NULL, num_samples = 100, ...)
}
\arguments{
\item{x}{An instance of \code{lbbnn_net}.}

\item{type}{Either \code{"global"} or \code{"local"}.}

\item{data}{If local is chosen, one sample must be provided to obtain
the explanation. Must be a \code{torch::torch_tensor} of shape \code{(1,p)}.}

\item{num_samples}{integer, how many samples to use for model averaging
over the weights in case of local explanations.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value. Called for its side effects of producing a plot.
}
\description{
Given a trained \code{lbbnn_net} model, this function produces either:
\itemize{
\item \strong{Global plot}: a visualization of the network structure,
showing only the active paths.
\item \strong{Local explanation}: a plot of the local
explanation for a single input sample, including error bars obtained
from Monte Carlo sampling of the network weights.
}
}
