% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_model.R
\name{abc_timeslice}
\alias{abc_timeslice}
\title{Apply time-sliced ABC model for validation}
\usage{
abc_timeslice(
  entity_data,
  time_column = "publication_year",
  split_time,
  a_term,
  a_type = NULL,
  c_type = NULL,
  min_score = 0.1,
  n_results = 100
)
}
\arguments{
\item{entity_data}{A data frame of entity data with time information.}

\item{time_column}{Name of the column containing time information.}

\item{split_time}{Time point to split historical and future data.}

\item{a_term}{Character string, the source term (A).}

\item{a_type}{Character string, the entity type for A terms.}

\item{c_type}{Character string, the entity type for C terms.}

\item{min_score}{Minimum score threshold for results.}

\item{n_results}{Maximum number of results to return.}
}
\value{
A list with prediction results and validation metrics.
}
\description{
This function implements a time-sliced ABC model for validation.
It uses historical data to predict connections that will appear in the future.
}
