% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chandrasekaran.R
\name{chandrasekaran_II}
\alias{chandrasekaran_II}
\title{II approach of Chandrasekaran decomposition approach}
\usage{
chandrasekaran_II(
  mx1,
  mx2,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
\code{cc} numeric vector with one element per age group, and which sums to the total difference in life expectancy between population 1 and 2.
}
\description{
Following the notation given in Ponnapalli (2005), and the decomposition method can written as:
\deqn{
_{n}\Delta_{x} =
\frac{(e_x^2 - e_x^1)(l_x^2 + l_x^1)}{2}
-
\frac{(e_{x+n}^2 - e_{x+n}^1)(l_{x+n}^2 + l_{x+n}^1)}{2}
-
\frac{_{n}L_{x}^{1}}{l_{x}^{1}}
+
\frac{T_{x+n}^{2}}{l_{0}^{1}} \left( \frac{l_{x}^{1}}{l_{x}^{2}} - \frac{l_{x+n}^{1}}{l_{x+n}^{2}} \right)
}
where \eqn{_{n}\Delta_{x}} is the contribution of rate differences in age \eqn{x} to the difference in life expectancy implied by \code{mx1} and \code{mx2}. This formula can be averaged between 'effect interaction deferred' and 'effect interaction forwarded' from the Ponnapalli (2005).
}
\details{
setting \code{closeout} to \code{TRUE} will result in value of \code{1/mx} for the final age group, of \code{ax} and a value of 1 for the closeout of \code{qx}. This function gives numerically identical results to \code{arriaga_sym()}, \code{lopez_ruzicka_sym()}, and \code{chandrasekaran_III()}.
}
\examples{
a <- .001
b <- .07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
cc <- chandrasekaran_II(mx1, mx2, age = x)
e01 <- mx_to_e0(mx1, age = x)
e02 <- mx_to_e0(mx2, age = x)
(delta <- e02 - e01)
sum(cc)

\donttest{
 plot(x, cc)
}
}
\references{
\insertRef{arriaga1984measuring}{LEdecomp}
\insertRef{preston2000demography}{LEdecomp}
\insertRef{Ponnapalli2005}{LEdecomp}
}
