% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_parallel_utils.R
\name{call_llm_par}
\alias{call_llm_par}
\title{Parallel LLM Processing with Tibble-Based Experiments (Core Engine)}
\usage{
call_llm_par(
  experiments,
  simplify = TRUE,
  tries = 10,
  wait_seconds = 2,
  backoff_factor = 120^(1/tries),
  verbose = FALSE,
  memoize = FALSE,
  max_workers = NULL,
  progress = FALSE,
  json_output = NULL,
  start_jitter = 5
)
}
\arguments{
\item{experiments}{A tibble/data.frame with required list-columns 'config' (llm_config objects)
and 'messages' (character vector OR message list).}

\item{simplify}{Whether to cbind 'experiments' to the output data frame or not.}

\item{tries}{Integer. Number of retries for each call. Default is 10.}

\item{wait_seconds}{Numeric. Initial wait time (seconds) before retry. Default is 2.}

\item{backoff_factor}{Numeric. Multiplier for wait time after each failure. Default is 3.}

\item{verbose}{Logical. If TRUE, prints progress and debug information.}

\item{memoize}{Logical. If TRUE, enables caching for identical requests.}

\item{max_workers}{Integer. Maximum number of parallel workers. If NULL, auto-detects.}

\item{progress}{Logical. If TRUE, shows progress bar.}

\item{json_output}{Deprecated. Raw JSON string is always included as raw_response_json.
This parameter is kept for backward compatibility but has no effect.}

\item{start_jitter}{Calls are made after a uniformly distributed delay
between 0 and \code{start_jitter} seconds.}
}
\value{
A tibble containing all original columns plus:
\itemize{
\item \code{response_text} – assistant text (or \code{NA} on failure)
\item \code{raw_response_json} – raw JSON string
\item \code{success}, \code{error_message}
\item \code{finish_reason} – e.g. "stop", "length", "filter", "tool", or "error:\code{category}"
\item \code{sent_tokens}, \code{rec_tokens}, \code{total_tokens}, \code{reasoning_tokens}
\item \code{response_id}
\item \code{duration} – seconds
\item \code{response} – the full \code{llmr_response} object (or \code{NA} on failure)
}

The \code{response} column holds \code{llmr_response} objects on success, or \code{NULL} on failure.
}
\description{
Processes experiments from a tibble where each row contains a config and message pair.
This is the core parallel processing function. Metadata columns are preserved.
This function requires setting up the parallel environment using \code{setup_llm_parallel}.
}
\section{Parallel Workflow}{

All parallel functions require the \code{future} backend to be configured.
The recommended workflow is:
\enumerate{
\item Call \code{setup_llm_parallel()} once at the start of your script.
\item Run one or more parallel experiments (e.g., \code{call_llm_broadcast()}).
\item Call \code{reset_llm_parallel()} at the end to restore sequential processing.
}
}

\examples{
\dontrun{
# Simple example: Compare two models on one prompt
cfg1 <- llm_config("openai", "gpt-4.1-nano")
cfg2 <- llm_config("groq", "llama-3.3-70b-versatile")

experiments <- tibble::tibble(
  model_id = c("gpt-4.1-nano", "groq-llama-3.3"),
  config = list(cfg1, cfg2),
  messages = "Count the number of the letter e in this word: Freundschaftsbeziehungen "
)

setup_llm_parallel(workers = 2)
results <- call_llm_par(experiments, progress = TRUE)
reset_llm_parallel()

print(results[, c("model_id", "response_text")])

}
}
\seealso{
For setting up the environment: \code{\link{setup_llm_parallel}}, \code{\link{reset_llm_parallel}}.
For simpler, pre-configured parallel tasks: \code{\link{call_llm_broadcast}}, \code{\link{call_llm_sweep}}, \code{\link{call_llm_compare}}.
For creating experiment designs: \code{\link{build_factorial_experiments}}.
}
