% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_thres.R
\name{G_thres}
\alias{G_thres}
\title{Thresholding of pCOS dataframe}
\usage{
G_thres(pCOS_mat, theta)
}
\arguments{
\item{pCOS_mat}{Dataframe of pCOS values}

\item{theta}{Numeric threshold}
}
\value{
A matrix of 0s and 1s of which cells meet the threshold
}
\description{
Converts each column of a pCOS score matrix into binary indicators
}
\examples{
z_dat <- data.frame("A" = rnorm(500,0,1), "B" = rnorm(500,0,1), "C" = rnorm(500,0,1))
snn <- sim_SNN(z_dat, 10, 5)
vec_snn <- vector_SNN(z_dat, snn)
pCOSdat <- pCOS(z_dat, vec_snn)
G <- G_thres(pCOSdat, theta = 0.1)

}
