% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_tests.R
\name{poisson_lambda_one_way}
\alias{poisson_lambda_one_way}
\title{Test the equality of lambda parameters of poisson distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
poisson_lambda_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of lambda parameters of poisson distributions.
}
\details{
\itemize{
\item All lambdas are equal. (lambda_1 = lambda_2 ... lambda_k).
\item Alternative: At least one lambda is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rpois(150, 1)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
poisson_lambda_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rpois(50, 1), rpois(50, 2), rpois(50, 3))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
poisson_lambda_one_way(x, fctr, .95)
}
